/**
 * @author Deepak Nigam
 * 
 */
Ext.define('Academia.view.admission.selectionStage.DownloadSelectionTransferForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.downloadselectiontransferform',
	//plugins : "formlabelrequired",
	frame: false,
	method : 'POST',
	//cls:'customSearchPanel',
	standardSubmit : false,

	items : [{
		xtype : 'fieldcontainer',
		items : [{
			xtype: 'fieldcontainer',
			width: '100%',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'ACADEMY_LOCATION_ID',
				itemId: 'academyCombo',
				labelAlign: 'top',
				width: 536,
				displayField: 'value',
				valueField: 'id',
				//queryMode: 'remote',
				fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
				allowBlank:false,
				queryParam:'qry',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listeners: {
					/* select: function(combo, records, eOpts) {
				                	//this.nextSibling().setDisabled(false);
				                    this.up('form').loadDependentCombo(this.up('form').down('#programBatch_programId'), records, 'academyLocationId');
				                },*/
					render: function(combo) {
//						var storeUrl='Academia.store.common.AcademyStore';
						var storeUrl='Academia.store.user.UserAcademyLocationStore';
						if(this.up('form').checkUserAccess==true){
//							storeUrl='Academia.store.common.AcademyByUserStore';
							storeUrl='Academia.store.user.UserAcademyLocationStore';
						}
						var store = Ext.create(storeUrl);
						combo.bindStore(store);
					}
				}


			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				name : 'PROGRAM_ID',
				itemId : 'programId',
				store:'common.ProgramByAcademyLocationStore',
				displayField:'valueCode',
				valueField:'id',
				labelAlign: 'top',
				width: 256,
				typeAhead:true,
				forceSelection:true,
				//allowBlank:false,
				queryParam:'programName',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							},
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{code} / {value}'+
		                    '</div>';
		                }
		            }
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width: '100%',
			defaults: {
				labelAlign: 'top'
			},
			items :[{
		        xtype: 'customcombobox',
	            name: 'BATCH_ID',
	            itemId: 'batchCombo',
	            displayField: 'value',
	            valueField: 'id',
	            store:'common.BatchesByProgramId',
	            width: 256,
	            labelAlign: 'top',
	            minChars:3,
	            queryMode:'remote',
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            forceSelection:true,
//	            disabled : true,
	            fieldLabel: getCommonTranslation('BATCH'),
	            allowBlank:false,
	        	listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'+ 
						'</div>';
					}
				}
	        },{
	        	xtype: 'customcombobox',
	            name: 'SEAT_TYPE',
	            itemId: 'seatTypeCombo',
	            displayField: 'seatTypeName',
	            valueField: 'seatTypeId',
	            store:'common.SeatTypesByBatchId',
	            width: 256,
	            labelAlign: 'top',
//	            disabled : true,
	            progBatchSeatConfigId: null,
	            fieldLabel: getCommonTranslation('SEAT_TYPE'),
	            allowBlank:false
	        },{

        		xtype: 'customcombobox',
        		itemId: 'selectionStageCombo',
        		name:'PROGRAM_SELECTION_PROCESS_STAGE_ID',
                store: 'Academia.store.admission.selectionStage.SelectionStageFromSeatType',
        		fieldLabel: getAdmissionTranslation('SELECT_STAGE'),
                displayField: 'value',
                valueField: 'id',
                queryMode: 'local',
                width: 256,
                labelAlign: 'top',
                autoload: false,
                allowBlank: false
        	
				
			}]},{
				xtype: 'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				margin: '0 0 0 -46',
				defaults : {
					labelAlign : 'top'
				},
	    		cls: 'customSearchPanelBtnsFieldContainerCls customAdjustmentPanelLeftMargin',
				items: [{
					xtype: 'button',
					text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
					itemId: 'programBatchDownoladBtnId',
					formBind : true,
					ui: 'CustomBtnSubmit'
				},{
					xtype: 'button',
					text: getCourseTxCommonTranslation('RESET'),
					itemId: 'downloadResetBtn',
					buttonAlign: 'left',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE
				}]
			}]
	}]
});
