/**
 * @author Amit G
 */
Ext.define('Academia.view.admission.selectionStage.EffectiveMarksListReportWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.effectivemarkslistreportwin',
	title:getAdmissionTranslation('EFFECTIVE_MARKS'),
	frame: true,
	autoScroll:false,
	modal:true,
	id:'effectiveMarksWinItemId',
	method: 'POST',
	maxHeight:500,
	width: '60%',
	//height:'60%',
	height:400,
//	maxHeight: 600,
	padding:'10 10 10 10',
	items: [{

		xtype: 'fieldcontainer',
		width: '100%',
		layout: 'hbox',
		style:{'margin-left':'15px !important'},
		defaults: {
			labelAlign: 'top',
			width: 260
		},
		items: [{
			xtype: 'displayfield',
			fieldLabel : getAdmissionTranslation('APPLICANT_ID'),
			name: 'applicationID',
			itemId: 'applicationID',
			labelAlign: 'top',
			
		},{
			xtype: 'displayfield',
			fieldLabel : getAdmissionTranslation('APPLICANT_NAME'),
			name: 'applicantName',
			itemId: 'applicantName',
			labelAlign: 'top',
		}]
		},{

			xtype: 'fieldcontainer',
			width: '100%',
			layout: 'hbox',
			height: 250,
			defaults: {
				labelAlign: 'top'
			},
			items: [{
				xtype: 'grid',
				autoScroll:true,
				frame:false,
				border:true,
				viewConfig: {
					stripeRows: CONSTANTS.STRIPEROWS
				},
				store: 'admission.selectionStage.EffectiveMarksRecordGridStore',
				maxHeight:220,
				hideHeaders :false,
				width: '96%',
				style:{
					marginBottom:'5px',
					'position': 'relative !important'
				},
				features: [{
					ftype: 'summary',
					showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
				}],
				columns: [{
					header: getAdmissionTranslation('STAGE_NAME'),
					dataIndex: 'selectionStageName',
					flex:.2,
					summaryRenderer: function(value, summaryData, dataIndex) {
						return getFeeAndPaymentCommonTranslation('TOTAL');
					}
				},{
					header: getAdmissionTranslation('STAGE_EFFECTIVE_MARKS'),
					dataIndex: 'stageEffectiveMarks',
					flex:.2,
					sortable:true
				},{
					header: getAdmissionTranslation('WEIGHTAGE'),
					dataIndex: 'stageWeightage',
					flex:.2,
					renderer:function(value) {
						return value+ '%';
					}
				},{
					header: getAdmissionTranslation('MARKS_CONTRIBUTION'),
					dataIndex: 'marksContribution',
					summaryType: 'sum',
					flex:.2,
					summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
						return value;
					}
				}]
			}]	
		}]	
});