/**
 * This panel is used for the Override quota Limits form from the selection stage structure.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.selectionStage.OverrideQuotaLimits', {
    extend: 'Ext.form.Panel',
    alias: 'widget.overridequotalimits',
    title: getAdmissionTranslation('OVERRIDE_QUOTA_LIMITS'),
    autoScroll: true,
    frame:true,
    plugins : "formlabelrequired",
	standardSubmit: false,
    defaults: {
		labelAlign: 'top'
	},
    items: [{
    	xtype: 'hidden',
    	name: 'programSelectionProcesStageQuotaId'
    },{
    	xtype: 'fieldcontainer',
    	layout: {
    		type: 'hbox'
    	},
    	defaults: {
    		width: 256,
    		labelAlign: 'top'
    	},
    	items: [{
    		xtype: 'customcombobox',
            itemId: 'quotaCombo',
            store: 'Academia.store.admission.selectionStage.MandatoryQuotas',
            name: 'programSelectionProcesStageQuotaId',
            //QUOTA_PICKLIST programSelectionProcessStageId
            fieldLabel: getAdmissionTranslation('QUOTA'),
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            allowBlank: false,
            editable: false
        },  {
        	xtype: 'textfield',
        	fieldLabel: getAdmissionTranslation('CANDIDATES_SELECTED'),
        	readOnly: true,
        	name: 'selectedCandidates',
        	itemId: 'selectedCandidates',
        	submitValue: false
        }]
    }, {
    	xtype: 'fieldcontainer',
    	fieldLabel: getAdmissionTranslation('CURRENT_SEATS'),
    	layout: {
    		type: 'hbox'
    	},
    	defaults: {
    		width: 256,
    		labelAlign: 'top'
    	},
    	items: [{
    		xtype: 'textfield',
    		itemId: 'quotaMinSeats',
        	fieldLabel: getAdmissionTranslation('MINIMUM_SEATS'),
        	readOnly: true,
        	name: 'minSeats',
        	submitValue: false
        },  {
        	xtype: 'textfield',
        	itemId: 'quotaMaxSeats',
        	fieldLabel: getAdmissionTranslation('MAXIMUM_SEATS'),
        	readOnly: true,
        	name: 'maxSeats',
        	submitValue: false
        }]
    }, {
    	xtype: 'fieldcontainer',
    	fieldLabel: getAdmissionTranslation('CHANGE_TO'),
    	layout: {
    		type: 'hbox'
    	},
    	defaults: {
    		width: 256,
    		labelAlign: 'top'
    	},
    	items: [{
    		xtype: 'numberfield',
        	fieldLabel: getAdmissionTranslation('MINIMUM_SEATS'),
        	editable: true,
        	minValue: 0,
        	allowBlank: false,
        	vtype: 'numberrange',
        	totalNumberField: 'overriddenMaxSeat',
        	itemId: 'overriddenMinSeat',
        	name: 'overriddenMinSeat'
        },  {
        	xtype: 'numberfield',
        	fieldLabel: getAdmissionTranslation('MAXIMUM_SEATS'),
        	editable: true,
        	minValue: 0,
        	allowBlank: false,
        	vtype: 'numberrange',
        	variableNumberField: 'overriddenMinSeat',
        	itemId: 'overriddenMaxSeat',
        	name: 'overriddenMaxSeat'
        }]
    }, {
    	xtype: 'fieldcontainer',
    	layout: {
    		type: 'hbox'
    	},
    	defaults: {
    		width: 256,
    		labelAlign: 'top'
    	},
    	items: [{
    	    	xtype: 'nestedTextField',
    		    labelAlign: 'top',
    		    width: 256,
    	    	allowBlank: false,
    	    	displayField: 'value',
    	    	itemId: 'approverAuthority',
    	    	name: 'approvedBy',
    	    	fieldLabel: getAdmissionTranslation('APPROVED_BY'),
    	    	readOnly: true
	        },  {
	        	xtype: 'datefield',
	        	name: 'approvedDate',
	        	fieldLabel: getAdmissionTranslation('DATE_APPROVED'),
//	        	value: new Date(),
	        	editable: true,
	        	//--submitFormat: CONSTANTS.DATE_FORMAT,
//	            format: CONSTANTS.DATE_FORMAT,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
        }]
    }, {
    	xtype: 'textarea',
    	name: 'overrideReason',
    	width: 536,
    	fieldLabel: getCommonTranslation('REMARKS')
    }, {
        xtype: 'button',
        itemId: 'saveSelectionSetting',
        ui: 'CustomBtnSubmit',
        formBind:true,
        scale: CONSTANTS.BUTTONSIZE,
        text: getCommonTranslation('SAVE')
    }]
});
