/**
 * @author Amit G
 * This is used to show CONDITIONS_FOR_ADMISSION list grid pop up
 */
Ext.define('Academia.view.admission.selectionStage.SelectionStageConditionsAdmission', {
    extend: 'Ext.window.Window',
    alias: 'widget.selectionstageconditionsadmission',
    title: getAdmissionTranslation('CONDITIONS_FOR_ADMISSION'),
    modal : true,
	resizable:true,
	autoScroll: true,
	//height: 'auto',
	height: '63%',
	width: '43%',
	items: [{
		xtype: 'form',
		itemId: 'selectionstageconditionsadmissionFormId',
		plugins: "formlabelrequired",
		standardSubmit: false,
		items:[{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			items: [{
				xtype: 'textarea',
				fieldLabel: getAdmissionTranslation('CONDITIONS_APPLICABLE'),
				width: 465,
				name: 'conditionApplicable',
				itemId: 'conditionApplicableId',
				style:{'margin-left':'10px'},
				allowBlank: true
			}]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype:'checkbox',
				itemId : 'whetherDocumentApplicable',
				name:'whetherDocumentApplicable',
				style:{'margin-left':'10px'},
				boxLabel:getAdmissionTranslation('WHETHER_DOCUMENTS_APPLICABLE'),
				inputValue: true,
				uncheckedValue: false
			}]},
			{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'hbox'
				},
				defaults: {
					labelAlign: 'top',
					width: 256
				},items: [{
					xtype: 'selectionstageconditionsdocumentlist',
					itemId: 'selectionstageconditionsdocumentlistId',
					hidden:true,
					width: 465
				}]
			},{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'hbox'
				},
				defaults: {
					labelAlign: 'top',
					width: 256
				},items: [{
					xtype: 'button',
					text: getCommonTranslation('SAVE'), 
					itemId: 'btnSave',
					ui: 'CustomBtnSubmit',
					style:{'margin-left':'10px'},
					scale: CONSTANTS.BUTTONSIZE,
					formBind : true
				}]
			}]
	}]
});