/**
 * This Grid is used for Stage Statistics Grid of the Selection Stage.
 * @author Amit G
 */
Ext.define('Academia.view.admission.selectionStage.StageFeeStatasticsGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport', 
	alias : 'widget.stagefeestatasticsgrid',
	title : getAdmissionTranslation('STAGE_FEE_STATISTICS'),
	border : true,
	columns : [/*{
		hidden: true,
		dataIndex: 'quotaTypeId'
	},*/{
		text : getAdmissionTranslation('STAGE_APPLICATION_ID'),
		dataIndex: 'applicantCode',
		flex: 1,
		sortable : false
	},  {
		text : getAdmissionTranslation('APPLICANT_NAME'),
		dataIndex: 'applicantName',
		flex: 1,
		sortable : true
	}, {
		text : getAdmissionTranslation('CURRENT_STAGE'),
		dataIndex : 'stageName',
		flex: 1,
		sortable : true
	},  {
		text : getAdmissionTranslation('STAGE_FEE_APPLICABLE'),
		dataIndex: 'whetherFeeApplicable',
		flex: 1,
		sortable : true,
		renderer:function(value) {
			if(value || value=='true'){
				return getAdmissionTranslation('YES');
			}else{
				return getAdmissionTranslation('NO');
			}
		}
	}, {
		text : getAdmissionTranslation('STAGE_FEE_STATUS'),
		dataIndex : 'billStatus',
		flex: 1,
		sortable : true,
		renderer:function(value) {
			if(isNullOrEmpty(value)){
				return getAdmissionTranslation('NA')
			}else{
				if(value=="SETTLED"){
					return getAdmissionTranslation('PAID');
				}else
				{
					return getAdmissionTranslation('UNPAID');
				}
			}
		}
	}],
	tbar : [{
		xtype:'fieldcontainer',
		layout : 'hbox',
		cls:'windowBtnPos',
		items: [{
			xtype: 'multiselectcombofield2',
			itemId: 'stagefeestatuscombo',
			labelWidth :110,
			fieldLabel: getAdmissionTranslation('STAGE_FEE_STATUS'), 
			displayField: 'value',
			width:400,
			style:{
				'margin-top':'13px !important'
			},
			valueField: 'id',
			queryMode: 'local',
			typeAhead: false,
			store: {
				fields: ['text', 'value', 'code'],
				data : [
					{"id":"SETTLED", "value":"Paid", "code": "Paid"},
					{"id":"PENDING", "value":"Unpaid", "code": "Unpaid"}
					]
			}
		},{
			xtype: 'button',
			itemId: 'stagefeestatussearch',
			tooltip: getExaminationTranslation('SAVE'),
			cls: 'CustomBtnSubmit applicantStageSearchCls',
			scale: CONSTANTS.BUTTONSIZE,
			tooltip : getAdmissionTranslation('Search'),
			text: getAdmissionTranslation('Search'),
			style:{
				marginTop: '28px !important',
				marginRight:'10px'
			}
		},{
			xtype:'displayfield',
			value:'System is allowed to bypass stage fee for this selection stage',
			hidden:true,
			itemId:'msgByPass',
			style:{
				marginTop: '24px !important',
				marginRight:'10px'
			}
		}]
	}/*{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		style:{
			bottom: '11px !important'
		},
		items: [{
			xtype: 'multiselectcombofield2',
			itemId: 'stagefeestatuscombo',
			labelWidth :110,
        	fieldLabel: getAdmissionTranslation('STAGE_FEE_STATUS'), 
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
    		typeAhead: false,
//    		width: 256,
    		store: {
				fields: ['text', 'value', 'code'],
				data : [
				        {"id":"SETTLED", "value":"Paid", "Paid": "Paid"},
				        {"id":"PENDING", "value":"Unpaid", "Unpaid": "Unpaid"}
				        ]
			}
		}]
	},{	
		xtype:'fieldcontainer',
		layout : 'hbox',
		style:{
			marginTop:'10px !important'
		},
		cls:'windowBtnPos',
		defaults: {
			labelAlign:'top',
		},
		items:[{
			xtype: 'button',
			itemId: 'stagefeestatussearch',
			tooltip: getExaminationTranslation('SAVE'),
			ui: 'CustomBtnSubmit',
	        scale: CONSTANTS.BUTTONSIZE,
	        tooltip : getAdmissionTranslation('Search'),
			text: getAdmissionTranslation('Search'),
			style:{
					marginRight:'10px',
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 536,
			labelAlign: 'top'
		},
		style:{
			marginTop:'10px !important'
		},
		items: [{
			xtype:'displayfield',
			value:'System is allowed to bypass stage fee for this selection stage',
//			hidden:true,
			itemId:'msgByPass',
//			layout:'vbox',
//			frame:true,	
		}]
	}*/],

	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.admission.selectionStage.StageFeeStatisticsStore');
	}
});