Ext.define('Academia.view.alumniSystem.alumniList.AlumniAddressForm', {
	extend : 'Ext.form.Panel',
   // extend:'Academia.view.common.IdGeneratorCustomForm',
  alias : 'widget.alumniAddressForm',
	autoScroll: true,
	defaults : {
		labelAlign:'top',
		enforceMaxLength : true,
		width: 256
	},
	items : [{
		xtype: 'fieldcontainer',
		itemId: 'topFieldContainer',
		layout: {
			type: 'hbox'
	    },
	    width:450
	},{
    		xtype : 'hidden',
    		name : 'id'
        },{
        	xtype : 'hidden',
    		name : 'version'
        },{
    	    xtype: 'fieldcontainer',
    	    width: 'auto',
    	    defaults: {
    	    	labelAlign: 'top',
    	    	width: 256
    	    },
    	    layout: {
    		type: 'hbox'
    	    },
    	    items: [{
    	    	 xtype: 'checkboxfield',
    	            labelAlign: 'right',
    	            boxLabel: getAlumni('COMMUNICATION_ADDRESS'),
    	            name: 'isPrimary',
    	            itemId:'communicationAddressItemId',
    	            cls:'checkBoxCstmAddressLabel',
    	            inputValue: true,
    	        	height:45,
    	            uncheckedValue: false,
    	            width:'235px !important'
            	},{
            		 xtype: 'checkboxfield',
                     labelAlign: 'right',
                     boxLabel: getAlumni('LEGAL_ADDRESS'),
                     name: 'isLegalAddress',
                     itemId:'legalAddressItemId',
                     inputValue: true,
                     cls:'checkBoxCstmAddressLabel',
         			height:45,
                     uncheckedValue: false,
                     width:'235px !important',
            	}]
    	}, {
		xtype : 'textareafield',
		fieldLabel : getAlumni('ADDRESS'),
		name : 'addressLine1',
		itemId : 'addressLine1',
		allowBlank:false,
        enforceMaxLength : true,
        maxLength : 255,
		width: 536
	}, {
		xtype : 'textareafield',
		fieldLabel : getAlumni('ADDRESS_OTHER_LANGUAGE'),
		name : 'addressLine2',
		itemId : 'addressLine2',
        enforceMaxLength : true,
        maxLength : 255,
		width: 536
	},{
	    xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	    	labelAlign: 'top',
	    	width: 256
	    },
	    layout: {
		type: 'hbox'
	    },
	    items: [{
        		xtype : 'customcombobox',
        		fieldLabel : getCommonTranslation('ADDRESS_COUNTRY'),
        		hiddenName : 'country',
        		itemId : 'country',
        		store:'common.CountryStore',
        		valueField : 'id',
        		displayField : 'countryName',
        		name : 'country',
        		//editable : false,
        		//valueNotFoundText:"",     
    			queryParam:'countryName',   		        						
				forceSelection :true,
				allowBlank:false,
				typeAhead : false,
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				hideTrigger:false,
				listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{countryName}'  +
		                    '</div>';
		                }
		            }
        	},{
        		xtype : 'customcombobox',
        		fieldLabel : getCommonTranslation('COUNTRY_REGION'),
//        		name : 'genericField1',
        		itemId : 'parentCountryRegion',
        		//store:Ext.create('Academia.store.organization.CountryRegionStore'),
        		store:'organization.CountryRegionStore',
        		valueField : 'id',
        		displayField : 'countryRegionName',
        		name : 'parentCountryRegion',
    			queryParam:'regionName',   		 
        		//editable : false,
        		//valueNotFoundText:"",        		        						
				forceSelection :true,
				allowBlank:false,
				typeAhead : false,
				hideTrigger:false,
				minChars:3,
				disabled:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{countryRegionName}'  +
		                    '</div>';
		                }
		            }
        	}]
	}, {
	    xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	    	labelAlign: 'top',
	    	width: 256
	    },
	    layout: {
		type: 'hbox'
	    },
	    items: [{
    		xtype : 'customcombobox',
    		fieldLabel : getAlumni('ADDRESS_CITY'),
    		hiddenName : 'city',
    		itemId : 'cityId',
    		store:'organization.CityByCountryRegion',
    		valueField : 'id',
    		displayField : 'value',
    		name : 'city',
			queryParam: 'searchText',   		
			forceSelection :true,
			typeAhead : false,
			allowBlank:false,
			minChars:3,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }
    	},{
    		xtype : 'textfield',
    		fieldLabel : getAlumni('PINCODE'),
    		itemId : 'pincodeId',
    		name : 'pincode',
    		allowBlank:false,
    		minValue : 0,
    		maxLength: 7,
    		maskRe:/^[a-zA-Z0-9\s]+$/,
    	}]
	    },{
		    xtype: 'fieldcontainer',
		    width: 'auto',
		    fieldLabel : getAlumni('GEOGRAPHICAL_AREA'),
		    itemId : 'geographicalAreaContainer',
			name : 'geographicalAreaContainer',  	
		    defaults: {
		    	labelAlign: 'top',
		    	width: 256
		    },
		    layout: {
			type: 'hbox'
		    },
		    items: [{
	    		xtype : 'textfield',
	    		hiddenName : 'Latitude',
	    		itemId : 'latitudeItemId',
	    		name : 'latitude',  		        		
	    		maxLength:100,
				emptyText: getAlumni('LATITUDE')
	    	},{
	    		xtype : 'textfield',
	    		hiddenName : 'Longitude',
	     		itemId : 'longitude',
	    		name : 'longitude',
	    		maxLength:100,
	    		emptyText: getAlumni('LONGITUDE')
	    	}]
		    }
	]

});
