Ext.define('Academia.view.alumniSystem.alumniList.AlumniDetailsLinkPanel', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.alumnidetailslinkpanel',
    collapsible: true,
    autoScroll: true,
    border: true,
    bodyCls: 'persondetailslinkpanelFont',
    defaults: {
        bodyStyle: 'padding:5px',
        autoScroll: true,
        minHeight: 170
    },
    layout: {
        type: 'accordion',
        titleCollapse: true,
        animate: true,
        fill: true
    },
    initComponent: function() {
        var this$ = this;
        var items = this$.getPersonLinkPanel();
        this$.items = items;
        this$.callParent(arguments);
    },

    getPersonLinkPanel: function() {
        var this$ = this;
        var panelArray = new Array();
        
        personInfo = this$.getAlumniProfileLink();
        
        for (var key in personInfo) {
            var alumniDetailsObj = personInfo[key];
            var alumniDetailsPanel = Ext.create('Ext.panel.Panel', {
                title: getPersonModuleTranslation(key),
                itemId: key,
                floatable: true,
                layout: {
                    type: 'vbox'
                },
                bodyStyle: {
                    padding: '10px'
                }
            });
            this$.getPersonDetailsLink(alumniDetailsPanel, alumniDetailsObj);

            panelArray.push(alumniDetailsPanel);

        }

        return panelArray;
    },
    getPersonDetailsLink: function(alumniDetailsPanel, alumniDetailsObj) {
        var store = Ext.create('Ext.data.Store', {
            extend: 'Ext.data.Store',
            fields: ['tabPanelItemId', 'tabPanelTitle', 'tabPanelItemXtype', 'xtypeItemId', 'isMandatoryTab', 'defaultPanel', 'render', 'afterrender'],
            data: alumniDetailsObj
        });
        
        var afterrenderFlag = false;
        if(!isNullOrEmpty(store.findRecord('afterrender', "dvRendered"))) {
        	afterrenderFlag = true;
        }

        var alumniDetailsLink = Ext.create('Ext.view.View', {
            store: store,
            tpl: new Ext.XTemplate( '<tpl for="."><div style="cursor: pointer;" class="thumb-wrap1 personDetailLinkheightCLS">{tabPanelTitle:this.formatChange}'+'<tpl if="isMandatoryTab == true"><span style="color:red;">*</span></tpl>'+'</div></tpl>', {
                formatChange: function(inputValue) {
                    return getPersonModuleTranslation(inputValue);
                }
            }),
            itemSelector: 'div.thumb-wrap1',
            width: '100%',
            listeners: {
            	afterrender: !afterrenderFlag ? Ext.emptyFn : function(dv) {
            		setTimeout(function(){
            			var searchCombo = Ext.ComponentQuery.query('#personalDetailLinkSearchComboBox')[0];
            			var contentPanelActiveTab = dv.up('contentpanel').getActiveTab();
            			if(contentPanelActiveTab.isSubtabRequired){
            				dv.up('panel').expand();
                			var result = searchCombo.store.getAt(searchCombo.store.findExact('tabPanelItemXtype',contentPanelActiveTab.subtabXtype));
                			//Ext.query('#'+result.parentPanelSelector)[0].querySelectorAll(result.currentElementSelector)[result.currentItemIndex].click();
                			var nodeIndex = dv.getStore().find('tabPanelItemXtype', result.get('tabPanelItemXtype'));
                			if(nodeIndex != -1){
                    			var dataViewEl = dv.getEl();
                    			Ext.defer(function() {
                    				var childNodes = dataViewEl.dom.childNodes;
                    				var specificNode = childNodes[nodeIndex];
                    				specificNode.click();
                    			}, 1000);
                			}
            			}
            		}, 500);
            	}
            }
        });

        alumniDetailsPanel.add(alumniDetailsLink);
    },

    getAlumniProfileLink: function() {
        var alumniProfileLink = {
            'PERSONAL_INFORMATION': [{
                tabPanelTitle: getAlumni('PERSONAL_DETAILS'),
                tabPanelItemId: 'alumniPersonalDetails',
                tabPanelItemXtype: 'alumnipersonalinformationform',
                xtypeItemId: 'alumniPersonalInformationForm',
                render : true,
                defaultPanel: true
            },{
                tabPanelTitle: getAlumni('ADDRESS_DETAILS'),
                tabPanelItemId: 'alumniAddressDetails',
                tabPanelItemXtype: 'alumniaddressdetailsform',
                xtypeItemId: 'alumniAddressDetailForm',
                render : true,
                defaultPanel: false
            },{
                tabPanelTitle: getAlumni('EDUCATIONAL_DETAILS'),
                tabPanelItemId: 'alumniEducationalDetail',
                tabPanelItemXtype: 'alumnieducationhistoryform',
                xtypeItemId: 'alumniEducationForm',
                render : true,
                defaultPanel: false
            },{
                tabPanelTitle: getAlumni('PROFESSIONAL_DETAILS'),
                tabPanelItemId: 'alumniProfessionalDetail',
                tabPanelItemXtype: 'alumniprofessionaldetailform',
                xtypeItemId: 'alumniProfessionalDetail',
                render : true,
                defaultPanel: false
            }]
        };
        return alumniProfileLink;
    },
});