/**
 *  @author Niklesh T
 * 
 */
Ext.define('Academia.view.alumniSystem.alumniList.AlumniListFilter',{
	extend: 'Ext.form.Panel',
	alias : 'widget.alumniListFilter',
	autoScroll: false,
	bodyPadding:'10 10 10 11',
	frame:false,
	cls:'customSearchPanel',
	plugins:"formlabelrequired",
//	style:{
//		marginLeft:"8px"
//	},

	defaults: {
		labelAlign: 'top',
	},
	items:[{
        xtype: 'fieldcontainer',
        width : '100%',
		layout: {
			type : 'hbox'
		},
		defaults: {
			width: 256,
			labelAlign: 'top'
		},		
        items: [{
				xtype: 'customcombobox',
				fieldLabel:getAlumni('ALUMNI_ID'),
				name: 'alumniId',
				itemId:'alumniItemId',
				minChars:3,
				forceSelection:true,
				store: 'alumni.alumniList.AlumniIDStore',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				valueField: 'value',
				displayField: 'value',
				queryParam:'alumniCode',
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}
	        },{
				xtype: 'customcombobox',
				fieldLabel:getAlumni('STUDENT_ID'),
				name:'studentId',
				itemId:'studentItemId',
				forceSelection: true,
				minChars:3,
				store: 'alumni.alumniList.AlumniStudentIDStore',
				forceSelection:true,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				valueField: 'value',
				displayField: 'value',
				queryParam:'studentCode',
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}
			},{
				xtype : 'customcombobox',
				fieldLabel : getAlumni('NAME'),		
				name : 'alumniName',
				itemId : 'alumniNameItemId',
				minChars:3,
				forceSelection:true,
				store: 'alumni.alumniList.AlumniNameStore',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}
			}],			
    	},{

    		xtype: 'fieldcontainer',    
    		layout: {
    			type : 'hbox'
    		},
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},	
    		items : [
    			{
        			xtype: 'customcombobox',
    				fieldLabel:getAlumni('EMAIL_ID'),
    				name: 'alumniEmail',
    				itemId:'alumniEmailItemId',
    				minChars:3,
    				forceSelection:true,
    				store: 'alumni.alumniList.AlumniEmailIdStore',
    				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    				valueField: 'value',
    				displayField: 'value',
    				queryParam:'emailId',
    				listConfig: {
    					listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        					}
        				},
        				loadingText: getCommonTranslation('SEARCHING'),
        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        			}
    			},{
    				xtype: 'customcombobox',
    				fieldLabel:getAlumni('MOBILE_NUMBER'),
    				name:'alumniMobile',
    				itemId:'alumniMobileItemId',
    				forceSelection: true,
    				minChars:3,
    				typeAhead:true,
    				triggerAction: 'all',
    				store: 'alumni.alumniList.AlumniMobileNoStore',
    				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    		        valueField: 'value',
    		        displayField: 'value',
    				queryParam:'mobileNo',
    				listConfig: {
    					listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        					}
        				},
        				loadingText: getCommonTranslation('SEARCHING'),
        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        			}						
    			},{
					xtype : 'customcombobox',
					fieldLabel : getAlumni('ACADEMY_LOCATION'),		
					name : 'alumniALName',
					itemId : 'alumniALItemId',	
					store:'alumni.alumniList.AlumniALStore',
					forceSelection:true,					
					valueField: 'id',
					displayField: 'value',
					queryParam:'query',
					editable: true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					minChars:3,
					listConfig: {
						listeners: {
	    					beforeshow: function(picker) {
	    						picker.minWidth = picker.up('combobox').getSize().width;
	    					}
	    				},
	    				loadingText: getCommonTranslation('SEARCHING'),
	    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    			}
					}
				]
    	},{


    		xtype: 'fieldcontainer',    
    		layout: {
    			type : 'hbox'
    		},
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},	
    		items : [
    			{
	    				xtype: 'customcombobox',
	    				fieldLabel:getAlumni('PROGRAM'),
	    				name:'alumniProgram',
	    				itemId:'alumniProgramItemId',
	    				store: Ext.create("Academia.store.common.ProgramStore"),
	    				forceSelection: true,
	    				valueField: 'id',
						displayField: 'value',
						queryParam:'programName',
						editable: true,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    				minChars:3,
	    				disabled: true,
	    				listConfig: {
	    					listeners: {
	        					beforeshow: function(picker) {
	        						picker.minWidth = picker.up('combobox').getSize().width;
	        					}
	        				},
	        				loadingText: getCommonTranslation('SEARCHING'),
	        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        			}	
					},{
						xtype: 'customcombobox',
						fieldLabel:getAlumni('BATCH'),
						store: 'alumni.alumniList.AlumniBatchStore',
						name:'alumniBatch',
						itemId:'alumniBatchItemId',
						forceSelection: true,
						queryParam:'qry',
						editable: true,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						minChars:3,				
						valueField: 'id',
						displayField: 'value',
						disabled: true,
						listConfig: {
							listeners: {
		    					beforeshow: function(picker) {
		    						picker.minWidth = picker.up('combobox').getSize().width;
		    					}
		    				},
		    				loadingText: getCommonTranslation('SEARCHING'),
		    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    			}
					},{
						xtype: 'customcombobox',
						fieldLabel:getAlumni('STATUS'),
						store: Ext.create('Academia.store.alumni.alumniList.AlumniStatusStore'),
						name:'alumniStatus',
						itemId:'alumniStatusItemId',			
						valueField: 'value',
						displayField: 'value',
						disabled: false,
						editable: false
					}
				]
    		
    	},{
    		xtype: 'fieldcontainer',    
    		layout : {
    			type : 'hbox'
    		},
    		width:'auto',
    		cls: 'customSearchPanelBtnsFieldContainerCls',
    		items : [{
    			xtype : 'button',
    			text : getCommonTranslation("SEARCH") ,
    			name : 'submitBtn',
    			itemId : 'submitBtn',
    			ui : 'CustomBtnSubmit',
    			scale : CONSTANTS.BUTTONSIZE,
    			formBind : true
    		},{
    			xtype: 'button',
    			itemId: 'resetBtn',
    			name: 'resetBtn',
    			text: getCommonTranslation("RESET"),
    			ui:'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE,
    		}]
    	
    	}]
});

