/**
 *  @author Niklesh T
 */

Ext.define('Academia.view.alumniSystem.alumniPortalSetUp.AddAlumniSetUpMappingGrid', {
	extend : 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.addAlumniSetUpMappingGrid',
	title : getAlumni('ACADEMY_LOCATION'),
	store: 'alumni.alumniPortalSetUp.AlumniPortalApplyToAlGridMapppingStore',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		//checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: false,
	cls:'horizontalScrollingFixed',
	height:460,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	border: true,
	tbar: [{
		xtype:'button',
		itemId: 'submitBtn',
		text:getAlumni('SUBMIT'),
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'customcombobox',
		name: 'academylocationsearchcombo',
		itemId:'academylocationsearchcombo',
		store: 'alumni.alumniPortalSetUp.AlumniPortalApplyToAlGridMapppingStore',
		valueField: 'id',
		displayField: 'value',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'name',
		queryMode: 'remote',
		width: 256,
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		}
	}],
	columns: [{
		header : getAlumni('ACADEMY_LOCATION'),
		dataIndex : 'value',
		flex : 1	 
	}]
});