/**
 * @author Niklesh Tiwane
 */
Ext.define('Academia.view.alumniSystem.alumniUploadDownloadStructure.AlumniUploadForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.alumniuploadform',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	items : [
		{
		xtype: 'customcombobox',
		name: 'importUtilityMasterId',
		itemId:'moduleName',
		store:'importutility.ModuleName',
		fieldLabel: getAlumni('TEMPLATE_NAME'),
		valueField: 'id',
		displayField: 'value',
		typeAhead:true,
		forceSelection:true,
		allowBlank:false,
//		hidden:true
	},{
		xtype : 'filefield',
		ui : 'CustomBtnThird',
		width: 536,
		fieldLabel : getAlumni('UPLOAD_FILE'),
		buttonText : getAlumni('BROWSE_FILE'),
		itemId : 'uploadFileField',
		name : 'file',
		allowBlank:false,
		validateOnChange : true,
		listeners:{
            change: function(fileField, value) {
                value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
                    if (!baseController.isValidFileExtensionForLoader(extension)) {
                        fileField.reset();
                        showWarningMessage(getAlumni('ALERT'), getAlumni('PLEASE_UPLOAD_CSV_FILE')); 
                    }
                }
            }
        }
	},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		style: {
			'margin-left': '-32px !important;'
		},
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getAlumni('UPLOAD_DATA'),
			formBind: true,
			itemId: 'uploadId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'resetBtn',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]});
