/**
 * Akshay Sharma
*/
var courseWiseStore = Ext.create('Academia.store.attendance.ConsolidateAttendanceGridStore');
Ext.define('Academia.view.attendance.ConsolidateAttendanceCourseWiseGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.consolidateattendancecoursewisegrid',
	store : courseWiseStore,
	title : getProgramandcourseTranslation('DAILY_ATTENDANCE_SUMMARY'),
	border: true,
	refreshStoreData:true,
	selType:'checkboxmodel',
	id:'consolidateattendancecoursewisegridId',
	hidden:true,
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'attendancemainstructure':1
		}
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar : [{
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		itemid:'dockedItemsItemId',
		items : [ {
		      xtype: 'custompagingtoolbar',
	          plugins:['pagesize'],
			store : courseWiseStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}
	],
	initComponent: function() {

        var grid=this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     

 },
	columns : [{
		header : getCommonTranslation('COURSE'),
		dataIndex : 'courseName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVaraintName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('SECTION'),
		dataIndex : 'sectionCode',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('FACULTY'),
		dataIndex : 'facultyName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('DATE'),
		dataIndex : 'date',
		sortable : true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getProgramandcourseTranslation('SESSION_TIME'),
		dataIndex : 'sessionTime',
		sortable:true
	},{
		header : getCommonTranslation('TOPICS_COVERED'),
		dataIndex: 'assignedTopicCount',
		flex:2,
		sortable:true,
		renderer: function(val,rec,record,rowIndex,colIndex,store,view) {
    		if(record.data.assignedTopicCount > 0){
    			value="<a href='#'>View</a>"; 
        		return value;
    		} else {
        		return '';
    		}
    	}
	
	},{
		header : getCommonTranslation('TOTAL_STUDENTS'),
		dataIndex : 'totalStudents',
		flex : 1,
		sortable : true,
		renderer : function(value,records) {
			if(value > 0){
				return '<a href="#">'+value+'</a>';
			}else{
				return "0";
			}
		}
	},{
		header : getCommonTranslation('PRESENT'),
		dataIndex : 'totalPresents',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('ABSENT'),
		dataIndex : 'totalAbsents',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('OTHERS'),
		dataIndex : 'totalLeaves',
		flex : 1,
		sortable : true,
	},{
		header : getCommonTranslation('WHETHER_ATTENDANCE_MARKED'),
		//dataIndex : 'lastUpdate',
		dataIndex : 'lastUpdate',
		sortable : true,
		renderer:function(timestamp) {
			return dateTimeRender1(timestamp);
		}
	}]
});
