/**
 * Akshay Sharma
 * 
 */
Ext.define('Academia.view.attendance.ConsolidateSearchAttendance', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.consolidatesearchattendance',  
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype : 'fieldcontainer',
		width: 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [
		         //		for course Level Course Drop-Down *************
		         {
		            	xtype: 'customcombobox',
	        			name: 'programGroup',
	        			itemId:'ProgramGroupItemId',
	        			fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
	        			store:'personinfo.common.personalinfo.AttendanceReportProgramGroupStore',
	        			editable: false,
	        			valueField: 'id',
	        			displayField: 'value',
	        			forceSelection:true,
		            }]
	},{
		xtype : 'fieldcontainer',
		itemId:'programBatch_Id',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'hidden',
			name : 'id'
		},
		{
			xtype : 'hidden',
			name : 'attendanceType'
		},{
			xtype : 'hidden',
			name : 'facultyAttendanceType'
		},
		// for complete day ********************
		{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			name : 'programId',
			itemId : 'programBatch_programId',
			store:'common.ClassTeacherProgramStore',
			displayField:'valueCode',
			valueField:'id',
			triggerAction: 'all',
    	    queryParam:'name',
            minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection:true,
            allowBlank:false,
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }

		},
		{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'programBatch_batchId',
			fieldLabel : getCourseTxCommonTranslation('BATCH'),
			disabled:true,
			store: 'enquiry.AcademicBatchStore',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			editable: false,
			forceSelection:true,
			allowBlank:false,
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId:'periodIdItemId',
			fieldLabel: getExaminationTranslation('PERIOD'),
			store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			editable: false,
			disabled:true,
			allowBlank:false
		}
		]},
		// This drop down is for both condition complete day and and multiple section and
//		for program base section also  ******************* 
		{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('SECTION'),
				width: 256,
				labelAlign: 'top',
				name : 'sectionId',
				itemId : 'programCoursection_ID',
				store:'attendance.SectionAndFacultyByPeriodID',
				displayField : 'sectionCode',
				valueField : 'sectionId',
				typeAhead : true,
				disabled:true,
				editable: false,
				forceSelection : true
			},{
				xtype: 'customcombobox',
				name:'facultyName',
				itemId:'facultyName_Id',
				store: 'attendance.FacultyCodeSmartSearch',
				fieldLabel :getCommonTranslation('FACULTY_CODE'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'codeOrName',
				minChars:3,
				hidden:false,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}

			},
			{
				xtype: 'customcombobox',
				 width: 256,
				fieldLabel: getProgramandcourseTranslation('SESSION_NO'),
				name:'sessionNo',
				itemId: 'sessionItemId1',
				displayField: 'val',
				valueField: 'code',
				allowBlank:true,
				editable: false,
				value:1,
				queryMode:'local',
				forceSelection:true
			},
		]},
		{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [
			{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('START_DATE'),
				name : 'consolidateStartDate',
				itemId:'consolidateStartDate',
				endDateField : 'consolidateEndDate',
				format : CONSTANTS.DATE_FORMAT,
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype : 'daterange',
				maxValue:new Date()
			},{
				xtype : 'datefield',
				fieldLabel :getProgramandcourseTranslation('END_DATE'),
				name : 'consolidateEndDate',
				itemId : 'consolidateEndDate',
				startDateField : 'consolidateStartDate',
				format : CONSTANTS.DATE_FORMAT,
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype : 'daterange',
				maxValue:new Date()
				
			}
			]},
			
		{
			xtype: 'fieldcontainer',
			width: '100%',
			layout: 'hbox',
    		cls: 'customSearchPanelBtnsFieldContainerCls',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true,
				margin: '0 44 0 16'
			},{
				xtype: 'button',
				text: getCommonTranslation('VIEW_QR'),
				itemId: 'GenrateQR',
				ui: 'CustomBtnSubmit',
				formBind : false,
				disabled:true,
				scale: CONSTANTS.BUTTONSIZE
			},
			{
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE	        				
			}]
		}
		]
});
