/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.attendance.DownloadCourseLevelAttendancePBSForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.downloadcourselevelattendancepbsform',
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype : 'fieldcontainer',
		items : [{
			xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                name: 'programId',
                itemId: 'program_ID',
                fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
                width: 536,
                valueField: 'id',
                displayField: 'code',
                store:'common.AssignedProgramStore',
                allowBlank: false,
                minChars:3,
	            queryParam:'name',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
            },{
                xtype: 'customcombobox',
                name: 'batchId',
                itemId: 'batch_ID',
                fieldLabel: getPersonModuleTranslation('BATCH'),
                width: 256,
                disabled:true,
                editable: false,
                queryMode: 'local',
                displayField: 'value',
                valueField: 'id',
                store:'enquiry.AcademicBatchStore',
                allowBlank: false,
            }]
        },{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width: '100%',
			defaults: {
				labelAlign: 'top'
			},
			items :[{
                xtype: 'customcombobox',
                name: 'periodId',	      
                itemId:'period_ID',
                disabled:true,
                width: 256,
                editable: false,
                displayField: 'value',
                valueField: 'id',
                store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
                queryMode: 'local',
                fieldLabel: getPersonModuleTranslation('PERIOD'),
                allowBlank: false,
            },{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('SECTION'),
				width: 256,
				labelAlign: 'top',
				name : 'sectionId',
				itemId : 'section_ID',
				store:'attendance.SectionAndFacultyByPeriodID',
				displayField : 'sectionCode',
				valueField : 'sectionId',
				typeAhead : true,
				disabled:true,
				forceSelection : true,
				allowBlank: false
			}]
		},{
			xtype: 'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults : {
				labelAlign : 'top'
			},
    		cls: 'customSearchPanelBtnsFieldContainerCls',
    		style: {
				'margin-left': '-42px !important;'
			},
			items: [{
	           	 xtype: 'button',
	        	 text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
	             itemId: 'downoladBtnId',
	             formBind : true,
	             ui: 'CustomBtnSubmit'
	        },{
                xtype: 'button',
                text: getCourseTxCommonTranslation('RESET'),
                itemId: 'resetBtn',
                buttonAlign: 'left',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
		}]
	}]
});
