/**
 * @author Utsav Chandvaniya
 * 
 */
Ext.define('Academia.view.attendance.LeaveReportFaculty',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.leavereportfaculty',
	plugins : "formlabelrequired",
	method : 'POST',
	standardSubmit : false,
	layout : {
		type : 'vbox'
	},
	defaults : {
		labelAlign : 'top',
		width: 256,
		margin: 0
	},
	items : [/*{
		xtype:'form',
		frame:false,
		width:'100%',
		items: [*/{
			xtype : 'fieldcontainer',
			itemId:'leavereportfaculty_id',
			// width : '100%',
			width: 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name:'facultyId',
				itemId:'facultyId_itemId',
				store: 'attendance.FacultyCodeSmartSearch',
				fieldLabel :getProgramandcourseTranslation('FACULTY_CODE'),
				valueField: 'value',
				displayField: 'valueCode',
				queryParam:'codeOrName',
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}

			},{
				xtype: 'customcombobox',
				name:'facultyName',
				itemId:'facultyName_itemId',
				store: 'attendance.FacultyNameSmartSearch',
				fieldLabel : getProgramandcourseTranslation('FACULTY_NAME'),
				valueField: 'valueCode',
				displayField: 'value',
				queryParam:'codeOrName',
				minChars:3,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}
			]},{
				xtype : 'fieldcontainer',
				width: 'auto',
				defaults : {
					width: 256,
					labelAlign : 'top'
				},
				layout : {
					type : 'hbox'
				},
				items : [{
					xtype : 'customcombobox',
					fieldLabel :getProgramandcourseTranslation('DEPARTMENT'),						
					name : 'departmentId',
					itemId : 'departmentId_itemId',
					store : 'course.CourseDepartmentStore',
					displayField : 'value',
					valueField : 'id'							
						//allowBlank:false
				},{

					xtype : 'customcombobox',
					fieldLabel :getProgramandcourseTranslation('SUB_DEPARTMENT'),						
					name : 'subDepartmentId',
					itemId : 'subDepartmentId_itemId',								
					store : 'course.CourseSubDepartmentStore',
					displayField : 'value',
					valueField : 'id'					
				}]
			},{
				xtype : 'fieldcontainer',
				width: 'auto',
				defaults : {
					width: 256,
					labelAlign : 'top'
				},
				layout : {
					type : 'hbox'
				},
				items : [{
					xtype : 'datefield',
					fieldLabel : getProgramandcourseTranslation('FROM_DATE'),
					name : 'fromDate2',
					itemId:'fromDate2',	
					endDateField : 'toDate2',
//					format : CONSTANTS.DATE_FORMAT,
					//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype : 'daterange',
    				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					}
    				}
				},{
					xtype : 'datefield',
					fieldLabel : getProgramandcourseTranslation('TO_DATE'),
					name : 'toDate2',
					itemId:'toDate2',
					startDateField : 'fromDate2',
					//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype : 'daterange',
    				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					}
    				}
				}
				]
			}]
//	}]
});
