/**
 * @author Utsav Chandvaniya
 * 
 */
Ext.define('Academia.view.attendance.LeaveReportStudent',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.leavereportstudent',
	plugins : "formlabelrequired",
	method : 'POST',
	standardSubmit : false,
	layout : {
		type : 'vbox'
	},
	defaults : {
		labelAlign : 'top',
		width: 256,
		margin: 0
	},
	items : [/*{
		xtype:'form',
		frame:false,
		width:'100%',
		items: [*/{
			xtype : 'fieldcontainer',
			itemId:'leavereportstudent_id',
			// width : '100%',
			width: 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name:'studentId',
				itemId:'studentId_itemId',
				store: 'attendance.StudentSearch',
				fieldLabel : getProgramandcourseTranslation('ADMISSION_CODE'),
				valueField: 'value',
				displayField: 'value',
				queryParam:'code',
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}

			},{
				xtype: 'customcombobox',
				name:'studentName',
				itemId:'studentName_itemId',
				store: 'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch',
				fieldLabel:getCourseTxCommonTranslation('STUDENT_NAME'),
				valueField: 'value',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}
			]},{
				xtype : 'fieldcontainer',
				width: 'auto',
				defaults : {
					width: 256,
					labelAlign : 'top'
				},
				layout : {
					type : 'hbox'
				},
				items : [{
					xtype : 'customcombobox',
					fieldLabel :getProgramandcourseTranslation('Program'),						
					name : 'programId',
					itemId : 'programId',
					store : 'common.ProgramByAcademyLocationStore',
					displayField : 'value',
					valueField : 'id'							
				},{
					xtype: 'customcombobox',
					name: 'batchId',
					itemId:'batchId',
					fieldLabel : getProgramandcourseTranslation('BATCH'),
					emptyText: getCommonTranslation('SELECT'),
					store: 'enquiry.AcademicBatchStore',
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true			        		 
				},{
					xtype : 'customcombobox',
					fieldLabel :getProgramandcourseTranslation('PERIOD'),						
					name : 'periodId',
					itemId : 'periodId',
					store : 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
					displayField : 'value',
					valueField : 'id'						
				}]
			},{
				xtype : 'fieldcontainer',
				width: 'auto',
				/*itmemId:'courseNsectionContainerId',
							hidden:true,*/
				defaults : {
					width: 256,
					labelAlign : 'top'
				},
				layout : {
					type : 'hbox'
				},
				items : [{
					xtype : 'customcombobox',
					width: 536,
					fieldLabel : getCourseTxCommonTranslation('COURSE'),
					name : 'courseId',
					itemId : 'courseId',
					store:'attendance.StudentCourses',
					displayField : 'courseCodeName',
					valueField : 'courseId',
					typeAhead : true,
					disable:true,
					forceSelection : true,
					allowBlank:false,
					hidden:true
				},{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('COMPONENT'),
					name : 'componentId',
					itemId : 'componentId',
					store:'course.coursecomponent.CourseComponentCouseWise',
					displayField : 'componentTypeName',
					valueField : 'componentTypeId',
					typeAhead : true,
					disable:true,
					forceSelection : true,
					hidden:true
				},{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('SECTION'),
					name : 'courseSectionId',
					itemId : 'CourseSection_ID',
					store:'attendance.SectionByCourseNComponent',
					displayField : 'sectionCode',
					valueField : 'sectionId',
					typeAhead : true,
					forceSelection : true,
					allowBlank:false,
					hidden:true
				}]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				itemId:'programBatchContainer',
				hidden:true,
				defaults: {
					width: 256,
					labelAlign: 'top'
				},
				items :[{
					xtype: 'customcombobox',
					fieldLabel: getCourseTxCommonTranslation('PROGRAM'),
					width: 536,
					name:'courseProgramId',
					itemId: 'courseProgramID',
					emptyText:getCourseTxCommonTranslation('SELECT'),
					store:'attendance.AllProgramMappedByCourse',
					displayField:'programName',
					valueField: 'programId',
					typeAhead:true,
					allowBlank:false,
					forceSelection:true
				},
				{
					xtype: 'customcombobox',
					fieldLabel: getCourseTxCommonTranslation('BATCH'),
					name:'programBatchCourse',
					itemId: 'courseBatchId',
					emptyText:getCourseTxCommonTranslation('SELECT'),
					store:'common.BatchesByProgramId',
					displayField: 'value',
					valueField: 'id',
					typeAhead:true,
					disabled:true,
					allowBlank:false,
					forceSelection:true
				},{
					xtype: 'customcombobox',
					fieldLabel: getCourseTxCommonTranslation('PERIOD'),
					name:'programBatchPeriod',
					itemId: 'coursePeriodID',
					emptyText:getCourseTxCommonTranslation('SELECT'),
					store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
					displayField: 'value',
					valueField: 'id',
					allowBlank:false,
					typeAhead:true,
					disabled:true,
					forceSelection:true
				}]
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('SECTION'),
				width: 256,
				labelAlign: 'top',
				name : 'sectionId',
				itemId : 'programCoursection_ID',
				store:'attendance.SectionAndFacultyByPeriodID',
				displayField : 'sectionCode',
				valueField : 'sectionId',
				typeAhead : true,
//				disabled:true,
				forceSelection : true
//				allowBlank: false
			},{
				xtype : 'fieldcontainer',
				width: 'auto',
				defaults : {
					width: 256,
					labelAlign : 'top'
				},
				layout : {
					type : 'hbox'
				},
				items : [{
					xtype : 'datefield',
					fieldLabel : getProgramandcourseTranslation('FROM_DATE'),
					name : 'fromDate3',
					itemId:'fromDate3',	
					endDateField : 'toDate3',
					//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype : 'daterange',
    				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					}
    				}
				},{
					xtype : 'datefield',
					fieldLabel : getProgramandcourseTranslation('TO_DATE'),
					name : 'toDate3',
					itemId:'toDate3',
					startDateField : 'fromDate3',
					//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype : 'daterange',
    				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					}
    				}
				}
				]
			}]
//	}]
});
