var StudentAttendanceListStore = Ext.create('Academia.store.attendance.StudentAttendanceList');
Ext.define('Academia.view.attendance.StudentAttendanceGrid', {
	 extend : 'Ext.form.FormPanel',
	 alias: 'widget.studentattendancegrid',
	 modal : true,
	 autoScroll: false,
	 frame: false,
	 margin: 0,
	 items:[{
		 xtype : 'panel',
		 width: 'auto',
		 layout : {
			 type : 'hbox'
		 },
		 style: {
			 marginBottom:'0px',
			 marginTop:'10px'
		 },
		 items : [{
			 xtype : 'radiogroup',
			 itemId:'markOnlyAttendance_Id',
			 items : []
		 },{
			 xtype: 'customcombobox',
			 itemId:'otherStatusId',
			 store:'attendance.AttendanceMarkingTypeStore',
			 valueField : 'value',
			 displayField : 'value',
			 typeAhead:false,
			 forceSelection : true,
			 hidden:true

		 }]
	 },{
		 xtype: 'grid',
		 store: StudentAttendanceListStore,
		 title:getProgramandcourseTranslation('STUDENT_ATTENDANCE_LIST'),
		 border:true,
		 isGridConfigurable: true,
		 enableColumnHide: false,
		 //autoScroll: false,
		 overflowY: 'visible',
		 isFixHeightGrid: true,
		 viewConfig: {
			// emptyText: getCommonTranslation('EMPTY_MESSAGE')
		 },
		 /*dockedItems: [{
				xtype : 'toolbar',
				dock : 'bottom',
				items : [ {
					xtype : 'custompagingtoolbar',
					plugins:['pagesize'],
					store : StudentAttendanceListStore,
					emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
					displayInfo : true
				} ]
			}],*/
		 columns : [{
			 xtype: 'rownumberer',
			 header: getCommonTranslation('SNO'),
			 sortable:false,
			 align :'left',
			 sortable:false,
			 flex:.5
		 },/*{
			 header : 'ID',
			 hidden : true,
			 dataIndex:'id'
		 },*/{
			 header :getCommonTranslation('ADMISSION_CODE'),
			 dataIndex : 'admissionCode',
			 sortable:true,
			 flex:1
		 },{
			 header :getCommonTranslation('STUDENT_CODE'),
			 dataIndex : 'studentCode',
			 sortable:true,
			 flex:1
		 },{
			 header : getCommonTranslation('STUDENT_NAME'),
			 dataIndex : 'studentName',
			 sortable:true,
			 flex:1
		 },{
			 header : getCommonTranslation('STUDENT_FIRST_NAME'),
			 dataIndex : 'firstName',
			 sortable:true,
			 flex:1,
			 hidden :true
		 },{
			 header : getCommonTranslation('STUDENT_MIDDLE_NAME'),
			 dataIndex : 'middleName',
			 sortable:false,
			 flex:1,
			 sortable:true,
			 hidden :true
		 },{
			 header : getCommonTranslation('STUDENT_LAST_NAME'),
			 dataIndex : 'lastName',
			 sortable:true,
			 flex:1,
			 renderer:function(val,rec,record,rowIndex,colIndex,store,view){
				  if(val=='null'){
					  
					  return '';
				  }else{
					  return val;
				  }
			  }

		 },{
			 header : getCommonTranslation('PROGRAM'),
			 dataIndex : 'programName',
			 sortable:false,
			 flex:1,
			 sortable:true
		 },{
			 xtype : 'checkcolumn', 
			 flex:.75,
			 itemId:'presentId',
			 sortable:false,
			 text : getCommonTranslation('PRESENT'), 
			 sortable:true,
			 dataIndex : 'present',
		 },{
			 xtype : 'checkcolumn',
			 text : getCommonTranslation('ABSENT'),
			 sortable:true,
			 dataIndex :  'absent',
			 flex : .75
		  },{
			  header : getCommonTranslation('OTHERS'),
			  dataIndex : 'attendanceStatus',
			  sortable:true,
			  flex : .75,
			  editor : {
				  xtype: 'customcombobox',
				  itemId:'StudentAttendanceStatus_Id',
				  store:'attendance.AttendanceMarkingTypeStore',
				  valueField : 'value',
				  displayField : 'value',
				  typeAhead:false,
				  forceSelection : true
			  },
			  renderer:function(val,rec,record,rowIndex,colIndex,store,view){
				  if(isNullOrEmpty(val)){
					  rec.tdCls = 'gridInputCustomStyle'; 
					  return getExaminationTranslation('CLICK_TO_ENTER');
				  }else{
					  return val;
				  }
			  }
		  },{
			  header: getCommonTranslation('REMARKS'),
			  dataIndex: 'comment',
			  flex:.75,
			  sortable:true,
			  editor : {
				  xtype: 'textfield',
				  name: 'attendanceComment',
				  maxLength:255
			  },
			  renderer:function(val,rec,record,rowIndex,colIndex,store,view){
				  if(isNullOrEmpty(val)){
					  rec.tdCls = 'gridInputCustomStyle'; 
					  return getExaminationTranslation('CLICK_TO_ENTER');
				  }else{
					  return val;
				  }
			  }
		  }],
		 plugins: [{
             ptype : 'cellediting',
             clicksToEdit: 1,
             listeners: {
                 edit: function(obj, editor, context){
                	 var this$= this;
  				   	 var grid = obj.grid;
  				   	 var store = grid.getStore();
  				   	 var models = grid.getStore().getRange();
  				     var gridCount = Ext.getCmp('studentAttendancecountGridId');
  				   	 var field = grid.down('#StudentAttendanceStatus_Id');
  				   	 if(obj.context.column.field.name != 'attendanceComment'){
  				   	 if(!isNullOrEmpty(field.getValue())){
	                 	 for(var i =0; i<store.data.length;i++){
	              		   if(editor.rowIdx==i){
	              			 models[i].set('present', false);
		                	 models[i].set('absent', false);
	              			  Ext.defer(function() {
		                		var preCount=0,absCount=0, other=0, presentSummaryCount = 0, absentSummaryCount= 0;
		        				   for(var i =0; i<store.data.length;i++){
		        					   if(models[i].data.present){
		        						   preCount++;
			        					   presentSummaryCount++;
		        					   }
		        					   else if(models[i].data.absent){
		        						   absCount++;
			        					   absentSummaryCount++;
		        					   }
		        					   else if(models[i].data.attendanceStatus){
		        						   other++;
		        						   for(var z = 0; z<this.grid.columnManager.columns.length;z++){
		        							   if(this.grid.columnManager.columns[z].dataIndex == "attendanceStatus") {
		        								   var data  = this.grid.columnManager.columns[z].field.getStore().data.items;
		        								   for(var j= 0; j<data.length;j++){
		        									   if(data[j].data.value == models[i].data.attendanceStatus){
		        										   if(data[j].data.code == 'PRESENT')
		        											   presentSummaryCount++;
		        										   if(data[j].data.code == 'ABSENT')
		        											   absentSummaryCount++;
		        										   models[i].set('attendanceMarkingType' ,data[j].data.id);
		        										   models[i].set('attendanceMarkStatus' ,data[j].data.code);
		        									   }
		        								   }
		        							   }
		        						   }
		        					   }
		        				   }
	    	                	   var  data = {
	    	                			   totalStudent:store.data.length,
	    	                			   totalPresent:preCount,
	    	                			   totalAbsent:absCount,
	    	                			   otherCount:other,
	    	                			   presentPercent:parseFloat((presentSummaryCount/store.data.length)*100).toFixed(2)+"%",
	    	                			   absentPercent:parseFloat((absentSummaryCount/store.data.length)*100).toFixed(2)+"%",
	    	                	   };
	    	                	   var gridStore =  gridCount.getStore();
	    		            		gridStore.removeAll();
	    		            		gridStore.loadRawData(data, true);
		                		
	              	        }, 50, this);
		                	    break;
	              		   }
                 	   }
              	    }
                 }
                 }
            }
		 }]
	 } ]
});
