/**
 * @author Akshay Sharma
 * 
 */
Ext.define('Academia.view.attendance.StudentLeaveReportFilter',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.studentleavereportfilter',
	cls:'customSearchPanel',
	autoScroll: true,
	items : [{
			xtype : 'fieldcontainer',
			width: 'auto',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel :getProgramandcourseTranslation('LEAVE_STATUS'),					
				name : 'leaveStatus',
				itemId : 'leaveStatusId',
				store : 'attendance.LeaveStatus',
				displayField : 'value',
				valueField : 'id',
				editable: false
			},{
				xtype: 'customcombobox',
				name: 'STUDENT_ID',
				itemId : 'studentName_itemId',
				fieldLabel: getServiceRequestTranslation('STUDENT_NAME'),
				store: 'feeandpayment.managebill.Student',
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'studentNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				hidden:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}
			}]
		},{
			xtype : 'fieldcontainer',
			width: 'auto',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('FROM_DATE'),
				name : 'fromDate3',
				itemId:'fromDate3',	
				endDateField : 'toDate3',
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype : 'daterange',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('TO_DATE'),
				name : 'toDate3',
				itemId:'toDate3',
				startDateField : 'fromDate3',
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype : 'daterange',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}
			]
		},{
			xtype: 'fieldset',
			collapsible : true,
			collapsed: true,
			title: getCommonTranslation('MORE_DETAILS'),
			titleCollapse: true,
			hidden:true,
			itemId : 'moreDetailId',
			defaults : {
				labelAlign:'top',
//				tdAttrs: { style: 'padding: 5px;' }
			},
			style: {
	          	 marginTop: '33px!important'
	         },
			items:[{
	        xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            labelAlign: 'top',
	            width: 256
	        },
	        items: [{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('PROGRAM'),
				name : 'programId',
				itemId : 'programBatch_programId',
				store:'common.AssignedProgramStore',
				displayField:'value',
				valueField:'id'
			
			},
			{
				xtype: 'customcombobox',
				name: 'batchId',
				itemId:'programBatch_batchId',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),
				disabled:true,
				store: 'enquiry.AcademicBatchStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			}]
	    }, {
	        xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            labelAlign: 'top',
	            width: 256
	        },
	        items: [{
				xtype: 'customcombobox',
				name: 'periodId',
				itemId:'periodIdItemId',
				fieldLabel: getExaminationTranslation('PERIOD'),
				store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				disabled:true
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('SECTION'),
				width: 256,
				labelAlign: 'top',
				name : 'sectionId',
				itemId : 'programCoursection_ID',
				store:'attendance.SectionAndFacultyByPeriodID',
				displayField : 'sectionCode',
				valueField : 'sectionId',
				typeAhead : true,
			    disabled:true,
				forceSelection : true
			},{
		    	xtype: 'customcombobox',
		        name: 'COURSE_NAME',
		        itemId:'course',
		        fieldLabel: getPersonModuleTranslation('COURSE'),
		        queryMode: 'local',
		        editable: false,
		        displayField : 'courseCodeName',
				valueField : 'courseId',
		        store : 'course.AssignedPeriodCoursesFacultyStore',
				
		    },{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('SECTION'),
			name : 'courseSectionId',
			itemId : 'CourseSection_ID',
			store:'attendance.SectionByCourseNComponent',
			displayField : 'sectionCode',
			valueField : 'sectionId',
			typeAhead : true,
			forceSelection : true,
		    disabled:true,
		    hidden:true
		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
			name : 'courseVariant',
			itemId : 'courseVariantId',
			store:'course.coursevariants.CourseVariantStore',
			displayField : 'courseVariantCode',
			valueField : 'id',
			typeAhead : true,
			forceSelection : true,
			hidden:true,
			disabled:true
		}]
	    }]},{
			xtype: 'fieldcontainer',
			width: 'auto',
    		cls: 'customSearchPanelBtnsFieldContainerCls',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'resetBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
//	}]
});