Ext.define('Academia.view.attendance.attendancereport.AttendanceDataStatusGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.attendancedatastatusgrid',
	store : 'attendance.attendancereport.AttendanceReportSummary',
	title:getProgramandcourseTranslation('STUDENT_ATTENDANCE_SUMMARY'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			store : 'attendance.attendancereport.AttendanceReportSummary',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}
	],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
	columns : [{
		header : getProgramandcourseTranslation('COURSE'),
		dataIndex : 'courseName',
		flex:1,
		hidden:true
	},{
		header : getProgramandcourseTranslation('SECTION'),
		dataIndex : 'sectionCode',
		flex : 1,
		hidden:true
	},{
		header : getProgramandcourseTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVaraintName',
		flex : 1.5,
		hidden : true
	},{
		header : getProgramandcourseTranslation('DATE'),
		dataIndex : 'date',
		flex : 1,
		renderer:function(value) {
			return dateRender(value);
		}
	},{
		header : getProgramandcourseTranslation('TIME'),
		dataIndex : 'fromTime',
		flex : 1,
		hidden:true,
		renderer:function(value, record){
			if(!isNullOrEmpty(record.record.data.fromTime)){
			return record.record.data.fromTime+" - "+record.record.data.toTime;
			}

		}
	},{
		header : getProgramandcourseTranslation('STATUS'),
		dataIndex : 'attendanceStatus',
		flex : 1
	},{
		header : getProgramandcourseTranslation('SESSION_NO'),
		dataIndex : 'sessionNo',
		flex : 1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			try{
				if(!isNullOrEmpty(val)){
					var form =Ext.ComponentQuery.query('attendancereportsearch')[0];
					var filter = form.down('#sessionItemId');
					var store = filter.getStore();
					for(var i =0;i<store.data.length;i++){
						if(store.data.items[i].data.code==val) {
							return store.data.items[i].data.val;
						} else  {
							return val;
						}
					}
				}
				return val;
			}
			catch(e){
				return val;
			}
		}
	},{
		header: getCommonTranslation('REMARKS'),
		dataIndex: 'attendanceComment',
		flex:1,
		hidden:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(isNullOrEmpty(val)){
	    		return "";
	    	} else {	    		
	    		rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
	    		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;';
	    		return val;
    		}
		}
	},{
		header : getProgramandcourseTranslation('FACULTY'),
		dataIndex : 'facultyName',
		flex : 1.5
	}]
});
