var MarkedAttendanceDetailGridStore = Ext.create('Academia.store.attendance.PendingAttendanceDatesGridStore');
Ext.define('Academia.view.attendance.pendingattendance.MarkedAttendanceDetailGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.markedattendancedetailgrid',
	store : MarkedAttendanceDetailGridStore,
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	title : getCommonTranslation('ATTENDANCE_MARKED_DETAILS'),
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : MarkedAttendanceDetailGridStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {

		var grid=this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     

	},
	columns :[{
		header : getCommonTranslation('DATE'),
		dataIndex : 'date',
		flex:1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('FROM_TIME'),
		dataIndex : 'fromTime',
		flex:1,
		renderer:function(fromTime) {
			return fromTime;
		}
	},{
		header : getCommonTranslation('TO_TIME'),
		dataIndex : 'toTime',
		flex:1,
		renderer:function(toTime) {
			return toTime;
		}
	},{
		header : getCommonTranslation('FACULTY'),
		dataIndex : 'facultyName',
		flex : 1,
		sortable : true,
	},{
		header : getCommonTranslation('TOTAL_STUDENT'),
		dataIndex : 'totalStudents',
		flex:1,
	},{
		header : getCommonTranslation('TOTAL_PRESENT'),
		dataIndex : 'totalPresents',
		flex:1,
	},{
		header : getCommonTranslation('ATTENDANCE_PERCENTAGE'),
		dataIndex : 'attendancePercentage',
		flex:1,
		renderer: function(value) {
			if(!isNullOrEmpty(value)){
				return value+'%';
			}else{
				return 0+'%';
			}
            
        }

	}]
});
