/**
 * @author ravindr
 * 
 */
Ext.define('Academia.view.attendance.pendingattendance.PendingCourseWiseSearchAttendance', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.pendingcoursewisesearchattendance',  
	plugins : "formlabelrequired",
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
	items: [{
		hidden : true,
		xtype : 'fieldcontainer',
		defaults : {
			//width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'radiogroup',
			itemId:'attendanceSearchId',
			defaults: {
				flex: 1
			},
			hidden:true,
			items : [{
				boxLabel : getProgramandcourseTranslation('STUDENT'),
				name:'attendanceDetials',
				inputValue : 'student',
				checked : true
			},{
				boxLabel : getProgramandcourseTranslation('FACULTY'),
				name:'attendanceDetials',	
				inputValue : 'faculty'

			}]
		}]},{
			xtype : 'fieldcontainer',
			width: 'auto',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),	
				name : 'courseWiseAcademicTerm',
				itemId : 'courseWiseAcademicTermId',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				editable: false,
				forceSelection : true,
				store : Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
				hidden : false,
				width: 256,
			},{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('INTAKE_YEAR'),
				store : Ext.create('Academia.store.common.BatchIntakeYearStore'),
				name: 'courseWiseIntakeYear',
				itemId: 'courseWiseIntakeYearId',
				displayField: 'value',
				valueField: 'id',
				width: 256,
				typeAhead: true,
				editable: false,
				forceSelection: true,
				listConfig: {
					listeners: {
						beforeshow: function(
								picker) {
							picker.minWidth = picker
							.up('combobox')
							.getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				} },{
					xtype : 'customcombobox',
					width: 256,
					fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
					name : 'courseWiseCourseName',
					itemId : 'courseWiseCourseId',
					store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourses'),
					displayField : 'courseCodeName',
					valueField : 'courseId',
					typeAhead : true,
					disable:true,
					forceSelection : true,
					queryParam:'name',
					minChars:3,
					typeAhead:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{courseCodeName}'  +
							'</div>';
						}
					}

				}]
		},{
			xtype : 'fieldcontainer',
			width: 'auto',
			defaults : {
				width: 536,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
				name : 'courseWiseCourseVariant',
				itemId : 'courseWiseCourseVariantId',
				store: Ext.create('Academia.store.attendance.facultyportal.AttendanceCourseVariantStore'),
				displayField : 'courseVariantCode',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				disabled:true,
				editable: false,
				width: 256

			},{
				xtype: 'customcombobox',
				name:'courseWiseFaculty',
				itemId:'courseWiseFacultyId',
				store: Ext.create('Academia.store.coursetransaction.facultytopicassignment.ParameterizedFaculties'),
				fieldLabel :getCommonTranslation('FACULTY_CODE'),
				displayField : 'value',
				valueField : 'id',
				queryParam:'name',
				minChars:3,
				hidden:false,
				typeAhead:false,
				width: 256,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}

			},{
				xtype : 'customcombobox',
				fieldLabel : getProgramandcourseTranslation('ATTENDANCE_STATUS'),
				width: 256,
				labelAlign: 'top',
				name : 'courseWiseAttendanceStatus',
				itemId : 'courseWiseAttendanceStatusId',
				store:'attendance.PendingAttendanceStatusStore',
				displayField : 'value',
				valueField : 'code',
				typeAhead : true,
				editable: false,
				forceSelection : true
			}]
		},{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout:'hbox',
			itemId:'dateContainer',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('START_DATE'),
				name : 'startDate',
				itemId:'startDate',
				endDateField : 'endDate',
				editable: false,
				vtype : 'daterange',
				maxValue:new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},{
				xtype : 'datefield',
				fieldLabel :getProgramandcourseTranslation('END_DATE'),
				name : 'endDate',
				itemId : 'endDate',
				editable: false,
				startDateField : 'startDate',
				vtype : 'daterange',
				maxValue:new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}

			}]
		},{
			xtype: 'fieldset',
			collapsible : true,
			collapsed: true,
			title: getCommonTranslation('MORE_DETAILS'),
			titleCollapse: true,
			itemId : 'moreDetailId',
			defaults : {
				labelAlign:'top',
			},
			style: {
				marginTop: '33px!important'
			},
			items:[{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 256
				},
				items: [{
					xtype: 'customcombobox',
					name: 'courseWiseProgramCategory',
					itemId : 'courseWiseProgramCategoryId',
					fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
					store: Ext.create('Academia.store.program.ProgramCategoryByAlStore'),
					valueField: 'id',
					displayField: 'value',
					forceSelection:true,
					editable: false,
					width: 256
				},{
					xtype : 'customcombobox',
					fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
					name : 'courseWiseProgram',
					itemId : 'courseWiseProgramId',
					store: Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'name',
					triggerAction: 'all',
					minChars:3,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}'  +
							'</div>';
						}
					}

				},{
					xtype: 'customcombobox',
					name: 'couseWiseBatch',
					itemId:'couseWiseBatchId',
					fieldLabel : getCourseTxCommonTranslation('BATCH'),
					disabled:true,
					editable: false,
					width: 256,
					store: Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true
				}]
			}, {
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 256
				},
				items: [{
					xtype: 'customcombobox',
					name: 'courseWisePeriod',
					itemId:'courseWisePeriodId',
					fieldLabel: getExaminationTranslation('PERIOD'),
					store: Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
					displayField:'value',
					valueField:'id',
					width: 256,
					editable: false,
					forceSelection:true,
					typeAhead:true,
					disabled:true
				}]
			}]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
    		cls: 'customSearchPanelBtnsFieldContainerCls',
    		layout: 'hbox',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'courseWisesearchBtnId',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'courseWiseresetBtnId',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE	        				
			}]
		}]
});
