/**
 * @author prathamesh.sheth
 *  
 * List of Activity Feeds screen.
 * 
 */
Ext.define('Academia.view.baselayout.header.ActivityFeedTypeGrid', {
	extend: 'Ext.grid.Panel',
    alias: 'widget.activityfeedtypegrid',
    title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'), //List of Activity Feeds	  
    border: true,
    autoScroll: false,
    store: 'authentication.ActivityFeedList',
    viewConfig: {
        stripeRows: false
    },    
    selType:'checkboxmodel',
    selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'activityfeeds':1
		}
	},
    columns: [{    	
    	header:getCommonTranslation('SUBJECT'), //Subject
        dataIndex: 'subject',
        flex: .2,
        minWidth:200,
        renderer: function(value,metaData,record) {
        	value = '<div style="display: flex;vertical-align: top;">'
  				+ '<div class="avtar-containerBox" style="vertical-align: middle;border-radius: 100%;border: 1px solid #ccc;width: 45px;text-align: center;height: 40px!important;line-height: 3;">'
  				+'<img src="resources/images/notification_type.svg" width="20" alt="">'
  				+'</div>'
  				+'<div class="student-name" style="vertical-align: middle; width: 150px;"> '+value+'</div>'
  				+ '</div>'	
  				return value;
        }
    }, {
    	header:getCommonTranslation('CONTENT'), //Content
        dataIndex: 'msgContent',
        flex: 1,        
        renderer: function(value,metaData,record) {
        	//metaData.tdAttr = 'data-qtip="' + value + '"';
        	var regex = /(<([^>]+)>)/ig;
        	var result = value.replace(regex, "");
        	result = result.replace("&nbsp;", " ");
        	result = result.trim();
        	
        	if(!isNullOrEmpty(result) && (!isEmpty(record.data) && !record.get("whetherRead"))){
        		result="<a href='#' style='text-decoration:none;color:#000;cursor: pointer;'><b>"+result+"</b></a>";
        	}else if(!isNullOrEmpty(result) && (!isEmpty(record.data) && record.get("whetherRead"))){
        		result="<a href='#' style='text-decoration:none;color:#000;cursor: pointer;'>"+result+"</a>";
        	}else if(!isNullOrEmpty(result)){
        		result="<a href='#' style='text-decoration:none;color:#000;cursor: pointer;'>"+result+"</a>";
        	}else if(isNullOrEmpty(result) && (!isEmpty(record.data) && !record.get("whetherRead"))){
        		result="<a href='#' style='text-decoration:none;color:#000;cursor: pointer;'><b>"+"Click here to see message"+"</b></a>";
        	}else{
        		result="<a href='#' style='text-decoration:none;color:#000;cursor: pointer;'>"+"Click here to see message"+"</a>";
        	}            	   
            return result;
        }
    }, {            	
    	header:getCommonTranslation('TIMING'), //Timing
         dataIndex: 'date_long',
        flex: .12,
        minWidth:200,
        renderer:function(date) {
			return dateRender(date)+'-'+timeRender(date);
		}       
    }],  
    tbar: [{
    	xtype: 'button',
		itemId: 'btnView',
		disabled:true,
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
    },{
     // Hide button as per discussion with @mrinal
        xtype: 'button',
        itemId: 'btnDelete',
        disabled:true,
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'), //Delete Activity Feed
        glyph: ICONGLYPH.DELETEGLYPH        
    },{
        xtype: 'notificationactivitygridextendeddatefilter',
        endDate: new Date(),
        startDate: Ext.Date.add(new Date(), Ext.Date.DAY, - 30),
        scale: CONSTANTS.BUTTONSIZE,
        itemId: 'dateRangePicker',
        hidden:true,
        text: getCommonTranslation('SELECT_DATE')
    }, {
        xtype: 'button',
        itemId: 'apply',
        scale: CONSTANTS.BUTTONSIZE,
        cls: 'dashbordOtherTbarBtn',
        align: 'bottom',
        hidden:true,
        text: getCommonTranslation('APPLY')
    }, {

        xtype: 'button',
        scale: CONSTANTS.BUTTONSIZE,
        align: 'bottom',
        hidden:true,
        text: getCommonTranslation('RESET'),
        cls: 'CustomBtnCancel',
        listeners: {
            click: function(obj) {
                var toolbar = this.up('toolbar');
                toolbar.down('#dateRangePicker').reset();
                obj.up().down('#dateRangePicker').down('form').getForm().reset();
                obj.up().down('#dateRangePicker').down('form').down('#toDayBtn').removeCls('dateFilterNotificationSearchBtnSelected');
                obj.up().down('#dateRangePicker').down('form').down('#lastWeekBtn').removeCls('dateFilterNotificationSearchBtnSelected');
                obj.up().down('#dateRangePicker').down('form').down('#lastMonthBtn').removeCls('dateFilterNotificationSearchBtnSelected');
                var contentPanelMain = obj.up('activityfeeds');
					 if(contentPanelMain){
							 contentPanelMain.scrollBy(0,1);
							 contentPanelMain.scrollBy(0,-1);
					 }
                
            }
        }
    }],
    dockedItems: [{
        xtype: 'toolbar',
       // hidden:true,
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            displayInfo: true,
            store: 'authentication.ActivityFeedList',
            emptyMsg :getCommonTranslation('EMPTY_MESSAGE') //No activity feed list to display
        }]
    }]
});
