/**
 * @author Akshay.Kalbhor
 * refers to the north-West portion of the header which contains the Client Logo and Name of the Org.
 */
Ext.define('Academia.view.baselayout.header.Logo', {
    extend: 'Ext.Container',
    alias: 'widget.logosection', // for referring to this component using xtype
    width: '100%',
    bodyCls: 'navbar navbar-default',
    baseCls: 'x-plain',
    style:{marginLeft:'8px'},
    initComponent: function() {
        if (this.loginPage == true) {
            this.layout = {
                type: 'hbox',
                pack: 'center'
            };
        } else {
            this.layout = {
                type: 'hbox',
                pack: 'start'
            };
        }

        this.items = [{
            xtype: 'image',
            maxWidth:500,
            minWidth:48,
            width:'auto',
            maxHeight: 48,
            margin: '8 4 8 0',
            src: 'resources/images/headerLogo/Academia_Monochrome.svg'
        }, {
        	xtype: 'container',
        	width: 1,
        	cls: 'devider',
        	margin: '20 0 0 0'
        }, {
            xtype: 'image',
            itemId: 'organizationLogo',
            maxWidth:80,
            width:'auto',
            maxHeight: 40,
            height: 40,
            margin: '8 0 0 16',
            cls: 'org-logo'
            //padding: '8',
            //ui: 'orgLogo'
           // src: 'resources/images/headerLogo/academiaLogo.png'
        }, {
            xtype: 'button',
            itemId: 'organizationName',
            cls: 'org-name-btn',
            margin: '0 0 0 16',
            hidden: true,
            //autoRender: true,
            //html: 'Academia ERP',
            //ui: 'orgName',
            menu: {
                cls: 'org-name-menu',
                 maxHeight: 600,
                 minHeight:256,
                 listeners: {
                     show: function (menu) {
                         var btn = menu.up('button'),
                         alId = btn.alId;

                         // highlight logic
                         if (alId) {
                             var targetItem = menu.down('[alId=' + alId + ']');
                             if (targetItem) targetItem.addCls('selected-lang');
                         }

                         // Add search field if it does not exist (always show)
                         if (!menu.down('#menuSearchField')) {
                             var searchField = Ext.create('Ext.form.field.Text', {
                                 itemId: 'menuSearchField',
                                 emptyText: getCommonTranslation('SEARCH'),
                                 enableKeyEvents: true,
                                 minWidth: 256,       // minimum width
                                 cls: 'alSearchFilterCls',
                                 margin: '5 5 5 5',
                                 fieldStyle: 'width:100%; box-sizing:border-box;',
                                 listeners: {
                                     keyup: function (field) {
                                         var val = field.getValue().toLowerCase();
                                         Ext.each(menu.items.items, function (item) {
                                             if (item.isXType('textfield')) return; // skip search field
                                             var match =
                                                 item.text &&
                                                 item.text.toLowerCase().indexOf(val) !== -1;
                                             item.setVisible(match);
                                         });
                                     },
                                 },
                             });

                             // Insert search field at the top
                             menu.insert(0, searchField);
                             menu.doLayout();
                         }
                     },
                    afterrender: function(menu) {
                        Ext.defer(function() {
                            menu.setHeight(menu.getHeight() + 2);
                        }, 10);
                    }
                }
            }
        }];

        this.callParent();
    }
});