/**
 * @author Harshit Satya
 * 
 * show list of notification/alert in notification window.
 *    
 */
Ext.define('Academia.view.baselayout.header.NotificationAlertForRecentVisitedStudents', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.notificationalertforrecentvisitedstudents',
    items: [{
    	xtype: 'dataview',
    	autoScroll: false,
        //store: 'userProfileLastActivity.notificationAlertForRecentVisitedUsers.NotificationAlertForRecentVisitedStudentsStore',
        //emptyText: '<div class="x-grid-empty">' + getCommonTranslation('NODATADISPLAYMSG') + '</div>',
        tpl: new Ext.XTemplate(
        		'<div class="notify-recent-visited-container notify-recent-visited-students">',
        	    '<tpl if="!values.length || values.length === 0">',
        	    '<div class="title" id="recentVisitedStdTitleId">{[getCommonTranslation("STUDENTS")]}</div>',
        	        '<div class="no-data-message"><span>{[getCommonTranslation("NO_STUDENT_PROFILES_VISITED")]} <a href="#" id="redirectToStdProfilePage">' + getAlumni("CLICK_HERE_REDIRECTION") + '</a></span></div>',
        	    '<tpl else>',
        	        '<div class="title" id="recentVisitedStdTitleId">{[getCommonTranslation("STUDENTS")]}</div>',
        	        '<div class="users-wrapper">',
        	            '<tpl for=".">',
        	                '<div class="user-box">',
        	                    '<div class="profile-img-wrapper">',
        	                    '<tpl if="imageURL && imageURL !== \'\'">',
        	                    '<img src="{[this.getFullImagePath(values.imageURL)]}" alt="{firstName} {lastName}" class="profile-img" ' +
        	                    'onerror="this.onerror=null; this.src=\'{[this.getFallbackImage(values.firstName, values.middleName, values.lastName)]}\';" ' +
        	                    'height="40" width="40">',
        	                '<tpl else>',
        	                    '<img src="{[this.getFallbackImage(values.firstName, values.middleName, values.lastName)]}" alt="{firstName} {lastName}" class="profile-img">',
        	                '</tpl>',
        	                    '</div>',
        	                    '<div class="user-name" data-qtip="{firstName} {lastName}">',
        	                    '{firstName} {lastName}',
        	                '</div>',
        	                '</div>',
        	            '</tpl>',
        	            '<div>',
        	                '<img src="resources/images/arrow_blue.svg" id="redirectToStdProfilePageId">',
        	            '</div>',
        	        '</div>',
        	    '</tpl>',
        	'</div>',
        	{
        		    getFullImagePath: function (imageURL) {
        		        var extensionArr = imageURL.split(".");
        		        var imageUrl = "resources/images/uploads" + extensionArr[extensionArr.length - 2] + "_icon." + extensionArr[extensionArr.length - 1];
        		        return imageUrl;
        		    },
        		    
        		    getFallbackImage: function (firstName, middleName, lastName) {
        		        return generateInitialsImage(firstName, middleName, lastName); // Assuming this is defined globally
        		    }
        		}

        )
    }]
});