Ext.define('Academia.view.baselayout.megamenu.VerticalNavigationMenuPanelItem', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.verticalNavigationMenuPanelItem',
    cls: 'MegaMenuPanelItemCtr',
    width: 200,
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
    bodyCls: 'thirdLevelMenuCls',
    initComponent: function() {
        this.callParent();
        // Add listeners to the title element for hover events
        this.on({
            afterrender: function(panel) {
                var header = panel.getHeader();
                if (header) {
                    header.getEl().on({
                        mouseenter: function() {
                        	if(document.querySelector('.dynamicClsForSecondLevel')){
                        		Ext.getCmp(document.querySelector('.dynamicClsForSecondLevel').id).removeCls('dynamicClsForSecondLevel');
                        	}
                        	panel.addCls('dynamicClsForSecondLevel');
                            panel.showThirdLevelMenu();
                        },
                       /* mouseleave: function(e, target, eOpts) {
                            // Delay hiding to allow mouse to move to third-level panel
                            Ext.defer(function() {
                                panel.hideThirdLevelMenu();
                            }, 100);
                        }*/
                    });
                }
            }
        });
    },
    initialize: function(items) {
        var this$ = this;
        var wheatherSchool = JSON.parse(localStorage.getItem("wheatherSchool")) || false;
        // Set the panel title as the second-level menu label
        this$.setTitle(getMenuDisplayName(items.displayCode));
        items.systemMenuHierachyModel.forEach(function(rec){
            rec.textContent=items.displayCode;
            rec.dataObj=rec;
            rec.moduleName=items.displayCode;
            rec.firstLevelMenuName=items.firstLevelMenuName

        });
        // Store items for third-level menu
        CONSTANTS.filterArryMainMenu = CONSTANTS.filterArryMainMenu.concat(items.systemMenuHierachyModel);
        
		this.headerDisplayCode = items.displayCode; 
        this$.thirdLevelItems = items.systemMenuHierachyModel || [];
        this$.thirdLevelItems.sort(function(a, b) {
            return a.displayOrder - b.displayOrder;
        });
    },
    showThirdLevelMenu: function() {
        var this$ = this;
        // Destroy existing third-level panel if any
        if (Ext.getCmp('thirdLevelPanel') && Ext.getCmp('thirdLevelPanel')) {
        	Ext.getCmp('thirdLevelPanel').destroy();
        }
        var wheatherSchool = JSON.parse(localStorage.getItem("wheatherSchool")) || false;
        var thirdLevelMenuItems = [];
        Ext.each(this$.thirdLevelItems, function(record) {
            var menuItem = {
                xtype: 'button',
                dataObj: record,
                width:260,
                isNewMenu:true,
                displayCode:this$.up('button').displayCode,
                index: record.displayOrder,
                text: getMenuDisplayName(record.displayCode),
                tooltip: getMenuDisplayName(record.displayCode),
                textAlign: 'left',
                cls: 'third-level-menu-item',
                handler: function(selModel, record, index, options) {
                	Academia.getApplication().getController('menu.CoreERPNavigationController').onNavSelectionChange(selModel, record, index, options, selModel.dataObj.textContent, selModel.dataObj.moduleName);
                    Ext.defer(function(){
                    	hideSecondLevelMenu();
                    	
                    },500)
                	
                }
            };
            if (wheatherSchool) {
                if (record.displayCode != "PC_REGISTRATION_SETUP" && 
                    record.displayCode != "EXAM_CANCELLATION" && 
                    record.displayCode != "EXAM_CANCELLATION_REQUEST") {
                    thirdLevelMenuItems.push(menuItem);
                }
            } else {
                thirdLevelMenuItems.push(menuItem);
            }
        });
     // Create third-level panel
        this$.thirdLevelPanel = Ext.create('Ext.panel.Panel', {
            floating: true,
            cls: 'thirdLevelMenuCls',
            id: 'thirdLevelPanel',
            autoScroll: true,
            width: 280,
            bodyPadding: 5,
            //minHeight: 256,
            maxHeight: 800,
            layout: {
                type: 'vbox',
                align: 'stretch'
            },
            items: thirdLevelMenuItems,
            renderTo: Ext.getBody(),
            listeners: {
                afterrender: function(panel) {
                	panel.el.dom.style.opacity = 0;
                	Ext.defer(function(){// Position to the right of the second-level panel
                        var panelXY = this$.up().getEl().getXY();
                        var desiredLeft = panelXY[0] + this$.getWidth() + 9;
                        var desiredTop = panelXY[1] ;
                        var secondLevlTop =this$.up().up().el.getTop();

                        // Get viewport height
                        var viewportHeight = Ext.Element.getViewSize().height;
                        // Get current height of the panel
                        try{
                        	if(panel && panel.getHeight && panel.getHeight()){
                            	var panelHeight = panel.getHeight();
                                var bottomMargin = 32;

                                // Adjust height if panel bottom exceeds viewport height
                                var panelBottom = desiredTop + panelHeight;
                                if (panelBottom > (viewportHeight - bottomMargin)) {
                                    panelHeight = viewportHeight - desiredTop - bottomMargin;
                                    if (panelHeight < 256) {
                                        panelHeight = 256; // Respect minHeight
                                       desiredTop = viewportHeight - panelHeight - bottomMargin; // Adjust top if needed
                                        if (desiredTop < 0) {
                                            desiredTop = 0;
                                            panelHeight = viewportHeight - bottomMargin; // Fit within viewport
                                        }
                                    }
                                    panel.setHeight(panelHeight); // Set adjusted height
                                }

                                // Set position using setPagePosition for Ext JS 4.2.1
                                panel.setPagePosition(desiredLeft, secondLevlTop);

                                // Bind mousedown and mouseleave listeners
                                Ext.getDoc().on('mousedown', this$._onDocClick, this$);
                                if (panel) {
                                    panel.getEl().on({
                                        mouseleave: function() {
                                            Ext.defer(function() {
                                                // this$.hideThirdLevelMenu(); // Commented out as per original code
                                            }, 10);
                                        }
                                    });
                                }
                                panel.el.dom.style.opacity = 1;
                            }
                        }catch(e){
                        	
                        }
                        
                        
                	},10);
                }
            }
        });
        this$.thirdLevelPanel.show();
    },
    hideThirdLevelMenu: function() {
        var this$ = this;
        if (this$.thirdLevelPanel) {
            this$.thirdLevelPanel.destroy();
            this$.thirdLevelPanel = null;
            
            hideSecondLevelMenu();
        }
    },
    _onDocClick: function(e) {
        var this$ = this;
        var thirdPanel = this$.thirdLevelPanel;

        if (!thirdPanel || !thirdPanel.getEl() || !thirdPanel.getEl().dom) return;

        var menuDom = thirdPanel.getEl().dom;
        var sourceDom = this$.getEl().dom;

        if (!menuDom.contains(e.getTarget()) && !sourceDom.contains(e.getTarget())) {
            this$.hideThirdLevelMenu();
        }
    }
});