Ext.define('Academia.view.calendar.AddCalendarForm', {
    extend: 'Academia.view.common.IdGeneratorForm',
    formCode: 'calendarForm',
    alias: 'widget.addcalendarform',
    autoScroll: true,
    method: 'POST',
    plugins: "formlabelrequired",
    standardSubmit: true,
    defaults: {
        width: 256,
        labelAlign: 'top'
    },
//    bodyStyle:{ margin:'6px'} ,
    style:{
    	marginLeft:'25px'
    },
    cls:'x-form-fixed-footer-parent',
    items: [{
        xtype: 'hidden',
        itemId: 'hiddenCalendarId',
        name: 'id'
    }, {
        xtype: 'hidden',
        itemId: 'version',
        name: 'version'
    }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: 'hbox',
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{
        xtype: 'textfield',
        name: 'code',
        itemId: 'calendarCode',
        fieldLabel: 'Calendar ID', //getCommonTranslation('ENQUIRY_CREATED_BY')
        maxLength: 10,
        //emptyText: getCommonTranslation('ID_AUTOGENERATE')   managed from controller(V2D-334702)
    }, {
        xtype: 'textfield',
        name: 'name',
        itemId: 'calendarName',
        fieldLabel: getCommonTranslation('CALENDAR_NAME'),
        allowBlank: false
    },{
    	xtype: 'customcombobox',
        name: 'calendarType', 
        itemId:'calendarType',
        store: 'calendar.CalendarTypeStore',
        displayField: 'value',
        valueField: 'id',
        typeAhead: true,
        fieldLabel:getCommonTranslation('CALENDAR_TYPE'),
        editable:false,
    }] },{
        xtype: 'textarea',
        name: 'description',
        itemId: 'calendarDescription',
        fieldLabel: getCommonTranslation('CALENDAR_DESCRIPTION'),
        allowBlank: false,
        maxLength: 100,
        width: 536
    },{
        xtype: 'fieldset',
        style: {
            marginTop: '35px !important'
        },
        width: 735,
        title: getCommonTranslation('CALENDAR_WEEKSTART'), // 'Week Start',
        items: [{
            xtype: 'radiogroup',
            itemId: 'weekStart',
            name: 'weekStart',
            vertical: true,
            width: '100%',
            allowBlank: false,
            defaults: {
            	style: {
            		marginRight: '0 !important;'
            	}
            },
            items: [{
                boxLabel: getCommonTranslation('MONDAY'),
                name: 'rb',
                inputValue: "MONDAY"
            }, {
                boxLabel: getCommonTranslation('TUESDAY'),
                name: 'rb',
                inputValue: "TUESDAY"
            }, {
                boxLabel: getCommonTranslation('WEDNESDAY'),
                name: 'rb',
                inputValue: "WEDNESDAY"
            }, {
                boxLabel: getCommonTranslation('THURSDAY'),
                name: 'rb',
                inputValue: "THURSDAY"
            }, {
                boxLabel: getCommonTranslation('FRIDAY'),
                name: 'rb',
                inputValue: "FRIDAY"
            }, {
                boxLabel: getCommonTranslation('SATURDAY'),
                name: 'rb',
                inputValue: "SATURDAY"
            }, {
                boxLabel: getCommonTranslation('SUNDAY'),
                name: 'rb',
                inputValue: 'SUNDAY'
            }]
        }]
    }, {
        xtype: 'fieldset',
        width: 735,
        title: getCommonTranslation('CALENDAR_WEEKLYOFF'), //'Weekly off',
        items: [{
            xtype: 'checkboxgroup',
            itemId: 'weeklyOff',
            name: 'weeklyOff',
            vertical: true,
            width: '100%',
            allowBlank: true,
            defaults: {
            	style: {
            		marginRight: '0 !important;'
            	}
            },
            items: [{
                boxLabel: getCommonTranslation('MONDAY'),
                name: "weeklyOffGroup",
                inputValue: "MONDAY",
                itemId: 'MONDAY'
            }, {
                boxLabel: getCommonTranslation('TUESDAY'),
                name: "weeklyOffGroup",
                inputValue: "TUESDAY",
                itemId: 'TUESDAY'
            }, {
                boxLabel: getCommonTranslation('WEDNESDAY'),
                name: "weeklyOffGroup",
                inputValue: "WEDNESDAY",
                itemId: 'WEDNESDAY'
            }, {
                boxLabel: getCommonTranslation('THURSDAY'),
                name: "weeklyOffGroup",
                inputValue: "THURSDAY",
                itemId: 'THURSDAY'
            }, {
                boxLabel: getCommonTranslation('FRIDAY'),
                name: "weeklyOffGroup",
                inputValue: "FRIDAY",
                itemId: 'FRIDAY'
            }, {
                boxLabel: getCommonTranslation('SATURDAY'),
                name: "weeklyOffGroup",
                inputValue: "SATURDAY",
                itemId: 'SATURDAY'
            }, {
                boxLabel: getCommonTranslation('SUNDAY'),
                name: "weeklyOffGroup",
                inputValue: 'SUNDAY',
                itemId: 'SUNDAY'
            }]
        }]
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	layout: 'hbox',
    	style: {
    		marginTop: '32px !important;'
    	},
    	defaults: {
    		width: 256,
    		labelAlign: 'top'
    	},
    	items: [{
	        xtype: 'statusCombo',
	        name: 'status',
	        itemId: 'calendarStatus',
	        fieldLabel: getCommonTranslation('CALENDAR_STATUS'),
	        editable: false,
	        value: true,
	        allowBlank: false
	    },{
			xtype:'checkbox',
			itemId : 'isSessionBreakdown',
			name:'isSessionBreakdown',
			style:{
				marginTop: '25px',
				marginLeft: '10px'
			},
			boxLabel:getCommonTranslation('SESSION_BREAEKDOWN'),
			inputValue: true,
			uncheckedValue: false,
			hidden:true,
		},{
			xtype : 'radiogroup',
			fieldLabel : getCommonTranslation('DAY_WISE_SCHEDULE'),
			itemId:'dayWiseScheduleId',
			defaults: {
				flex: 1
			},
			layout: 'hbox',
			items : [ {
				boxLabel : 'Yes',
				name : 'dayWiseSchedule',
				inputValue : true
			}, {
				boxLabel : 'No',
				name : 'dayWiseSchedule',
				inputValue : false,
				checked:true
			} ]
		}, {
			xtype : 'numberfield',
			name : 'dayPerCycle',
			itemId:'dayPerCycleId',
			fieldLabel : getCommonTranslation('DAY_PER_CYCLE'),
			minValue:1,
			maxValue:30,
			allowExponential :false,
			allowDecimals: false,
			hideTrigger:true,
			hidden:true,
			width: 256
		}] 
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        style: {
            marginTop: '10px'
        },
        cls:'form-fixed-footer',
        items: [{
            xtype: 'button',
            action: 'Submit',
            text: 'Save',
            formBind: true,
            itemId: 'btnSaveAddCalendar',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        },{
            xtype: 'button',
            text: getExaminationTranslation('RESET'),
            itemId: 'resetButtonId',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE,
            handler: function() {
                this.up('form').getForm().reset();
            }
        }]
    },{
        //Work Timing Configuration Grid
        xtype: 'worktimingconfigurationgrid',
        itemId: 'calendarWorkingWeekDaysGrid',
        hidden:true,
        width: 790,
        style: {
            marginLeft: 0
        }

    }, {
        //Breaks on Selected Day Grid
        xtype: 'worktimesloteditorgrid',
        itemId: 'workTimeSlotEditorGrid',
        hidden:true,
        width: 790,
        style: {
            marginLeft: 0
        }
    }, /*{
        xtype: 'holidaysandspecialdaystabstructure',
        itemId: 'holidaysAndSpecialDaysTabStructure',
        width: 800
    }*/]
});
