/**
 * @author Samarth.Ashturkar
 * This component is used for to Work Timing configuration Grid Details Window 
 */
Ext.define('Academia.view.calendar.holidaysandspecialdaystabs.SpecialDayBreaksFormWindow',
		{
			extend : 'Ext.window.Window',
			alias : 'widget.specialDayBreaksFormWindow',			
			modal : true,
			resizable:false,
			title : getCommonTranslation('CALENDAR_SPECIAL_DAY_BREAKS_DETAILS'),//'Special Day Breaks Details'						
			items : [{
				xtype: 'form',
				itemId:'specialDayBreaksForm',
			    method : 'POST',
			    margin:0,
			    bodyPadding:'10 10 10 10',
			    plugins : "formlabelrequired",
				defaults:{
					labelAlign:'top'
				},
//			    /standardSubmit : true,
			    items :[{
						xtype : 'hidden',
						itemId:'hidden_id_field',
						name : 'id'
					},{
						xtype : 'hidden',
						itemId:'hidden_calendarId_field',
						name : 'wsCalendarId'
					},{
						xtype : 'hidden',
						itemId:'wsCalendarWeekDayId',
						name : 'wsCalendarWeekDayId'
					},{
						xtype : 'hidden',
						itemId:'version',
						name : 'version'
					},{
						xtype : 'textfield',
						name : 'breakName',						
						fieldLabel : getCommonTranslation('CALENDAR_BREAK_NAME'),//Break Name
						itemId:'breakName',
						maxLength:15,
						allowBlank:false
					},{
						xtype : 'timefield',
						name : 'startTime',			
						itemId : 'startTime',			
						fieldLabel : getCommonTranslation('CALENDAR_START_TIME'),//'Start Time',
						format:'g:i A',
						vtype: 'timerange',
						endTimeField : 'endTime',
			            submitFormat: 'g:i A',
						allowBlank:false
					},{
						xtype : 'timefield',
						name : 'endTime',			
						itemId : 'endTime',		
						fieldLabel :getCommonTranslation('CALENDAR_END_TIME'),//'End Time',
						format:'g:i A',
						vtype: 'timerange',
						startTimeField : 'startTime',
			            submitFormat: 'g:i A',
						allowBlank:false
					},
					{
		        	xtype:'fieldcontainer',
		        	width:'100%',
		        	cls:'windowBtnPos',
		            items: [{
						xtype : 'button',				
						itemId:'btnSaveSpecialDayBreaksForm',
						text : getCommonTranslation('SAVE'), //Submit
						ui: 'CustomBtnSubmit',
		                scale: CONSTANTS.BUTTONSIZE,
		                formBind : true
					},{
						xtype : 'button',
						itemId:'btnCancelSpecialDayBreaksForm',
						text : getCommonTranslation('CANCEL'), //Cancel
						ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE
					}]
			    }]
			}]			
		});
