/**
 * This window is used for work time slot
 */

Ext.define('Academia.view.calendar.worktimingconfiguration.WorkTimeSlotFormWindow',{
	extend : 'Ext.window.Window',
	alias : 'widget.worktimeslotformwindow',			
	modal : true,
	resizable:false,
	title : getCommonTranslation('CALENDAR_WORK_TIMING_SLOT_DETAILS'),		
	items : [{
		xtype: 'form',
		itemId:'workTimeSlotForm',
	    method : 'POST',
	    margin:0,
	    bodyPadding:'10 10 10 10',
	    plugins : "formlabelrequired",
		defaults:{
			labelAlign:'top'
		},
	    standardSubmit : false,
	    items : [{
				xtype : 'hidden',
				itemId:'id_hidden_field',
				name : 'id'
		  },{
		    	xtype : 'hidden',
				name : 'dbId'
	      },{
		    	xtype : 'hidden',
				name : 'version'
	      },{
				xtype : 'hidden',
				itemId:'parent_hidden_field',
				name : 'parentId'
			}, {
	    	  	xtype: 'customcombobox',
	            fieldLabel: getCommonTranslation('SLOT_PURPOSE'),
	            name: 'slotPurpose',
	            valueField: 'name',
	            displayField: 'value',
	            itemId: 'slotPurpose',
	            store: 'calendar.SlotNameStore',
	            editable: false,
	            allowBlank: false,
				width: 256,
	            queryMode: 'local'
			}, {
				xtype : 'timefield',
				name : 'startTime',			
				itemId : 'startTime',			
				fieldLabel :getCommonTranslation('CALENDAR_START_TIME'),
				format: CONSTANTS.DISPLAY_TIME_FORMAT,
				vtype: 'timerange',
				endTimeField : 'endTime',
				width: 256,
				allowBlank:false,
				submitFormat : CONSTANTS.TIME_FORMAT_12hrs,
				listeners: {
					render: function(field) {
						return timeFormatRender(field);
					}
				}
			},{
				xtype : 'timefield',
				name : 'endTime',			
				itemId : 'endTime',			
				fieldLabel :getCommonTranslation('CALENDAR_END_TIME'),
				format: CONSTANTS.DISPLAY_TIME_FORMAT,
				//--submitFormat:CONSTANTS.SUBMIT_TIME_FORMAT,
				vtype: 'timerange',
				startTimeField : 'startTime',
				width: 256,
				allowBlank:false,
				submitFormat : CONSTANTS.TIME_FORMAT_12hrs,
				listeners: {
					render: function(field) {
						return timeFormatRender(field);
					}
				}
			},
			{
        	xtype:'fieldcontainer',
        	width:'100%',
        	cls:'windowBtnPos',
            items: [{
				xtype : 'button',				
				itemId:'btnSaveSlotOnSelectedDayForm',
				text : getCommonTranslation('SAVE'),
				ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind : true
			},{
				xtype : 'button',
				itemId:'btnCancelSlotOnSelectedDayForm',
				text : getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
			}]
	    }]
	}]			
});