/**
 * @author Samarth.ashturkar
 * 
 * This component is used for to show Work Timing Configuration Details Grid
 */
Ext.define('Academia.view.calendar.worktimingconfiguration.WorkTimingConfigurationGrid',
		{
			extend : 'Ext.grid.Panel',
			alias : 'widget.worktimingconfigurationgrid',
//			requires: ['Academia.view.calendar.worktimingconfiguration.WorkTimingConfigurationFormWindow'],
			title : getCommonTranslation('CALENDAR_WORK_TIMING_CONFIGURATION_DETAILS'),//'Work Timing Configuration Grid'
			collapsible:false,
			border: true,
			cls:'centerAlignTitle zero-left-margin-grid no-empty-placeholder-grid',
			isFixHeightGrid: true,
			viewConfig : {
 				stripeRows : CONSTANTS.STRIPEROWS
 		       	},
        	columns : [/*{
				dataIndex : 'id',
				hidden: true
			},*/ {
				header : getCommonTranslation('CALENDAR_DAY'),//Day
				dataIndex : 'weekday',
				align: 'center',
				sortable : true,	
			    flex : .2,
		        renderer: function(value) {
		            return getCommonTranslation(value);
		        }
			}, {
				header : getCommonTranslation('CALENDAR_START_TIME'),//'Start Time',
				dataIndex : 'startTime',
				align: 'center',
				sortable : true,	
				flex : .2
			}, {
				header : getCommonTranslation('CALENDAR_END_TIME'),//'End Time',
				dataIndex : 'endTime',	
				align: 'center',
				sortable : true,	
				flex : .2
			}, {
				header : getCommonTranslation('CALENDAR_TOTAL_TIME_SLOT'),//'Time Slot (In mins)'
				dataIndex : 'slot',	
				itemId:'slot',
				align: 'center',
				sortable : true,	
				flex : .2
			}
			],
			tbar : [ {
				xtype : 'button',				
				itemId : 'btnAddWorkTimingConfiguration',
				tooltip : getCommonTranslation('ADD'),//Add
				glyph: ICONGLYPH.ADDGLYPH
				//text : getCommonTranslation('ADD')
			},{
				xtype : 'button',				
				itemId : 'btnEditWorkTimingConfiguration',
				tooltip : getCommonTranslation('EDIT'),//Edit
				glyph: ICONGLYPH.EDITGLYPH
				//text : getCommonTranslation('EDIT
			},{
				xtype : 'button',				
				itemId : 'btnViewWorkTimingConfiguration',
				tooltip : getCommonTranslation('VIEW'),//View
				iconCls: 'view-icon'
				//text : getCommonTranslation('VIEW')
			},{
				xtype : 'button',				
				itemId : 'btnDeleteWorkTimingConfiguration',
				cls: 'CustomToolbarBtnReject',
				tooltip :getCommonTranslation('DELETE'),//Delete
				glyph: ICONGLYPH.DELETEGLYPH
				//text : getCommonTranslation('DELETE')
			},{
				xtype : 'button',				
				itemId : 'btnCopyWorkTimingConfiguration',
				text: getCommonTranslation('COPY'),
				glyph: '',
	            scale: CONSTANTS.BUTTONSIZE
			}],
			initComponent: function() {
		        var this$ = this;
		        var store = this$.buildStore();
		        Ext.apply(this$, {
		           store : store
		        });
		        this$.callParent(arguments);
		    },
			buildStore: function() {
		        return Ext.create('Academia.store.calendar.WorkTimingConfigurationGridStore');
		    }
		});
