/**
 * @author seshagiri.k
 */
Ext.define('Academia.view.campaign.CampaignsForm', {
    extend: 'Academia.view.common.CustomFieldForm',
    customFieldEntity:CONSTANTS.CAMPAIGN_CUSTOM_FIELD,
    columns: 1,
    addPosition: 11, 
    alias: 'widget.campaignsform',
    requires: ['Ext.ux.form.ItemSelector', 'Ext.ux.form.MultiSelect'],
    title: getCommonTranslation('TITLE_CAMPAIGN_DETAIL'),
    autoScroll: false,
    frame: true,
    modal: true,
    method: 'POST',
   /* layout: {
        type: 'vbox'
    },*/
    plugins: "formlabelrequired",
    defaults: {
        labelAlign: 'top',
        width: 256
    },
    items: [{
        xtype: 'hidden',
        name: 'id',
        itemId:'id'
    }, {
        xtype: 'hidden',
        name: 'idss'
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 256,
            labelAlign: 'top',
            regex: /[a-zA-Z0-9]+/
        },
        items: [{
            xtype: 'textfield',
            name: 'code',
            itemId: 'code',
            enforceMaxLength : true,
     	    minValue:0,
     	    maxLength: 20,
            fieldLabel: getCommonTranslation('CAMPAIGN_CODE'),
            emptyText: getCommonTranslation('ID_AUTOGENERATE'),
            readOnly:true
            //allowBlank: false
        }, {
        	xtype: 'textfield',
        	name: 'campaignName',
        	itemId: 'campaignName',
        	fieldLabel: getCommonTranslation('CAMPAIGN_NAME'),
        	allowBlank: false,
        	maxLength:50,
        	enforceMaxLength : true,
        	regex : /^[a-zA-Z0-9\-\/\\\s]+$/
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'datefield',
            name: 'fromDate',
            itemId: 'fromDate',
            vtype: 'daterange',
            endDateField: 'toDate',
            allowBlank: false,
          //  editable: false,
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            fieldLabel: getCommonTranslation('FROM_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        }, {
            xtype: 'datefield',
            name: 'toDate',
            itemId: 'toDate',
            vtype: 'daterange',
            startDateField: 'fromDate',
           // editable: false,
            allowBlank: false,
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            fieldLabel: getCommonTranslation('TO_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'numberfield',
            itemId: 'budgetAmount',
            name: 'budgetAmount',
            fieldLabel: getCommonTranslation('BUDGET_AMOUNT'),
            minLength: 2,
            maxLength: 12,
            minValue: 0,
            mouseWheelEnabled:false,
            allowDecimals:false,
            hideTrigger:true,
            keyNavEnabled :false
        }, {
            xtype: 'numberfield',
            name: 'actualAmount',
            fieldLabel: getCommonTranslation('ACTUAL_AMOUNT_SPENT'),
            hidden: true,
            maxLength: 12,
            allowDecimals:false,
            itemId: 'actualAmount',
            minValue: 0,
            mouseWheelEnabled:false,
            hideTrigger:true,
            keyNavEnabled :false
        }]
    }, {
    	xtype: 'customcombobox',
    	name: 'contactPerson',
        itemId: 'contactPerson1',
		store: 'campaign.ContactPersonWithoutAcadmyLoction',
		fieldLabel: getCommonTranslation('CAMPAIGN_CONTACT_PERSON'),
		valueField: 'id',
		displayField: 'valueCode',
		queryParam:'codeOrName',
		minChars:3,
		allowBlank: false,
		typeAhead:false,
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		hideTrigger:false,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		triggerAction: '',
        forceSelection:true,
		  listConfig: {
			  listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{value}' +
                    '</div>';
                }
            }
    }, {
        xtype: 'textarea',
        name: 'remarks',
        itemId: 'remarks',
        fieldLabel: getCommonTranslation('REMARKS'),
        width: 536,
        enforceMaxLength : true,
		maxLength:255,
    }, {
    	xtype : 'multiselectcombofield',
		width: 536,
		name : 'campaignMedias',
		itemId:'campaignMedias',
		fieldLabel: getCommonTranslation('CAMPAIGN_MEDIA_NAME'),
		store: 'campaign.MediaStructureStore',
        displayField: 'mediaName',
        valueField: 'id',
        allowBlank: false
    },/*{
        xtype: 'itemselector',
        name: 'campaignMedias',
        fieldLabel: getCommonTranslation('MEDIA_NAME'),
        width: 500,
        maxHeight:400,
        autoScroll:true,
        anchor: '100%',
        itemId: 'campaignMedias',
        imagePath: '../ux/css/images/',
        store: 'campaign.MediaStructureStore',
        displayField: 'mediaName',
        valueField: 'id',
        editable: false,
        allowBlank: false,
        fromTitle: getCommonTranslation('AVAILABLE_MEDIA'),
        toTitle: getCommonTranslation('SELECTED_MEDIA'),
        msgTarget: 'side',
        delimiter: null,
        buttons: ['top', 'add', 'remove', 'bottom']
       
    }, */{
        xtype: 'hidden',
        name: 'campaignMediaId'
    }/*, {
        xtype: 'textarea',
        fieldLabel: getCommonTranslation('SELECTED_MEDIA'),
        readOnly: true,
        itemId: 'multiselect',
        hidden: true,
        name: 'multiselect'
    }*/]
});