/**
 * @author swapnil.patil
 */
Ext.define('Academia.view.campaign.ProgramAssociatedGrid', {
	extend: 'Ext.window.Window',
	alias: 'widget.programAssociatedGrid',
	modal : true,
    title: getCommonTranslation('LIST_OF_CAMPAIGN_COVERAGE'),
    cls:'programassociatedwintitle',
	width: '60%',
	style:{'padding-bottom' : '10px'},
	items:[{
    	xtype: 'hidden',
    	itemId: 'campaignId'
    	}, {
        xtype: 'hidden',
        itemId: 'programId'
    	}, {
            xtype: 'hidden',
            itemId: 'whetherDeleted'
        	},{
        xtype: 'customcombobox',
        fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
        name: 'academyLocationId',
        itemId: 'academyLocationId',
        store:'common.AcademyLocationNameSeparated',
        displayField: 'value',
        valueField: 'id',
        labelAlign: 'top',
        width: 256,
        allowBlank:true,
        queryMode: 'remote',
        style:{'margin-left':'10px'},
        triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		minChars:3,
		typeAhead:false,
		forceSelection:true,
		triggerAction: '',
		hideTrigger:false,
        queryParam:'qry',
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}' +
				'</div>';
			}
		}
    
	},{
		xtype:'grid',
	    border: true,
	    refreshStoreData:true,
		maxHeight: 400,
		height:'100%',
	    autoScroll: true,
	    style:{'padding-top' : '10px'},
		itemId:'programAssociatedGridItemId',
	    store: 'campaign.ProgramAssociatedGridStore',
		dockedItems: [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [ {
				xtype : 'custompagingtoolbar',
				plugins:['pagesize'],
				store : 'campaign.ProgramAssociatedGridStore',
				emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
				displayInfo : true
			} ]
		}],
	    columns: [{
	        header: getCommonTranslation('ACADEMY'),
	        dataIndex: 'academyName',
	        flex: 1,
	        sortable: true
	    }, {
	        header: getCommonTranslation('LOCATION'),
	        dataIndex: 'locationName',
	        flex: 1,
	        sortable: true
	    }, {
	        header: getCommonTranslation('PROGRAM'),
	        dataIndex: 'programName',
	        flex: 1,
	        sortable: true
	    }]
	}],
    
});