Ext.define('Academia.view.campaign.dashboard.FollowUpDashboardFilter', {
	extend: 'Ext.form.FormPanel',
	alias : 'widget.followupdashboardfilter',
	//autoScroll: true,
	frame: false,
	//layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	cls: 'customSearchPanel',
	plugins:"formlabelrequired",
	defaults: {
		labelAlign: 'top',
		// width: 256
	},
	items:[{
		xtype:'fieldcontainer',
		itemId: 'followupDetailsConatiner',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		style :{
			  marginLeft: '6px'
		},
		items:[{
			xtype: 'multiselectcombofield',
			width: 690,
			height:58,
			name: 'multiselectAcademyLocation',
			itemId: 'academyLocationId',
			allowBlank : false,
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:'common.AcademyLocationNameSeparated',
			displayField:'value',
			valueField:'id',
			matchFieldWidth:true,
			maxLength:15000,
			queryMode:'local',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]  
	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		style: {
			//marginTop: '40px!important',
			marginLeft:'-0px !important'
		},
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		style :{
			  marginLeft: '6px'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'enquiryId',
			itemId:'enquiryId',
			valueField: 'id',
			displayField: 'valueCode',
			minChars:3,
			queryParam:'codeOrName',
			fieldLabel:getEnquiryTranslation('ENQUIRY_ID_OR_STUDENT_NAME'),
			store: 'enquiry.EnquiryCodeSearchStore',
			typeAhead:true,
			//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		},{
			xtype : 'customcombobox',
			fieldLabel : getEnquiryTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
			width: 256,
			//typeAhead:true,
			//forceSelection:true,
			editable: false,
			//minChars:3,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearStore');
					combo.bindStore(store)
				}}
		},{
			xtype: 'customcombobox',
			name: 'enquiryOwner',
			store: 'enquiry.FollowUpUserWithDepartment',
			fieldLabel: getEnquiryTranslation('ENQUIRY_OWNER'),
			valueField: 'id',
			displayField: 'value',
			itemId:'enquiryOwner',
			queryParam:'name',
			minChars:3,
			editable:true,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			//forceSelection:true,
			allowBlank:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'+
					'</div>';
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		style :{
			  marginLeft: '6px'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'programId',
			itemId:'programId',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			displayField:'valueCode',
			width: 536,
			valueField:'id',
			//typeAhead:true,
			store: 'program.ProgramByGroupIdStore',
			//forceSelection:true,
			minChars:3,
			queryParam:'qry',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			/*listeners: {
                    render: function(combo) {
                    	var store = Ext.create('Academia.store.program.ProgramByGroupIdStore');
                        combo.bindStore(store);
                    }
                },*/
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'batch',
			itemId:'batchId',
			fieldLabel: getEnquiryTranslation('BATCH'),
			store: 'enquiry.AcademicBatchStore',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			disabled:true,
			//forceSelection:true
		},{
			xtype : 'multiselectcombofield',
			cls:'commonAutoHeightMultiselectField',
			fieldLabel: getCommonTranslation('SEAT_TYPE'),
			name: 'seatType',
			itemId:'seatType',
			displayField: 'value',
			valueField: 'id',
			typeAhead : true,
			forceSelection : true,
			editable: false,
			disableKeyFilter: false,
			disabled:true,
			store:'enquiry.SeatTypeStore',
			listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
			return '<div class="search-item">' +
						'{code}'  + '{value}' +
				        '</div>';
			}
			}
		}]  
	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		style :{
			  marginLeft: '6px'
		},//followupuser
		items:[{
			xtype: 'customcombobox',
			name: 'followUpUser',
			store: 'enquiry.FollowUpUserWithDepartment',
			fieldLabel: getEnquiryTranslation('FOLLOW_UP_USER'),
			valueField: 'id',
			displayField: 'value',
			itemId:'followUpUser',
			queryParam:'name',
			minChars:3,
			editable:true,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'+
					'</div>';
				}
			}
		},
		{
			xtype: 'datefield',
			name: 'fromdate',
			itemId:'fromdate',
			allowBlank : false,
			
			vtype: 'daterange',
			endDateField: 'todate',
			fieldLabel: getFeeAndPaymentCommonTranslation('FROM_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},{
			xtype: 'datefield',
			name: 'todate',
			itemId:'todate',
			allowBlank : false,
			vtype: 'daterange',
			startDateField: 'fromdate',
			fieldLabel: getCommonTranslation('TO_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			// buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});
