var SignUpStore = Ext.create('Academia.store.signUpReport.SignUpReportStore');
Ext.define('Academia.view.campaign.dashboard.SignUpReportGrid',{
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.signupreportfiltergrid',
	title: getCommonTranslation('SIGNUP_REPORT_GRID'),
	store: SignUpStore,
	border: true,
	refreshStoreData:true,
	autoScroll: false,
	frame: false,
	//method: 'POST',
	selType:'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	isGridConfigurable:  true,
	enableColumnHide: false,
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'signupreportform':1
		}},
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store: SignUpStore,
				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
		initComponent: function() {
			var grid = this;
			grid.addExportToolBarItems(grid, false);
			this.callParent(arguments);
		}, 
		tbar : [{
			xtype : 'button',
			itemId : 'sendMessageBtn',
			tooltip : getCommonTranslation('SEND_MESSAGE'),
			text : getCommonTranslation('SEND_MESSAGE'),
			formBind:true,
		}, {
			xtype : 'button',
			itemId : 'exportReportsId',
			tooltip : getCommonTranslation('EXPORTREPORTS'),
			text : getCommonTranslation('EXPORTREPORTS'),
			formBind:true,
		}],
		columns: [{
			header: getCommonTranslation('FIRST_NAME'),
			dataIndex: 'firstName',
			flex: 1,
			sortable: true,
		},{
			header: getCommonTranslation('MIDDLE_NAME'),
			dataIndex: 'middleName',
			flex: 1,
			sortable: true
		},{
			header: getCommonTranslation('LAST_NAME'),
			dataIndex: 'lastName',
			flex: 1,
			sortable: true
		},{
			header: getCommonTranslation('SIGNUP_DATE'),
			dataIndex: 'signUpDate',
			flex: 1,
			sortable: true,
			renderer:function(date) {
				return dateRender(date);
			}
		},{
			header: getCommonTranslation('SIGNUP_FORM_NO'),
			dataIndex: 'formNo',
			flex: 1,
			sortable: true
		},{
			header: getCommonTranslation('SIGNUP_APPLICATION_ID'),
			dataIndex: 'applicationCode',
			flex: 1,
			sortable: true,
			renderer : function(value){
				if( !isNullOrEmpty(value) && value != 0 ){
					return  '<a href="#">'+value+'</a>';
				} else {
					return  '-';
				}
			}
		},{
			header: getCommonTranslation('SIGNUP_SOURCE_OF_INFORMATION'),
			dataIndex: 'sourceOfInformation',
			flex: 1,
			sortable: true
		},{
			header: getCommonTranslation('SIGNUP_PREFERRED_CAMPUS'),
			dataIndex: 'preferredCampus',
			flex: 1,
			sortable: true
		},{
			header: getEnquiryTranslation('EMAIL'),
			dataIndex: 'emailId',
			flex: 1,
			sortable: true
		},{
			header: getCommonTranslation('COUNTRY_CODE'),
			dataIndex: 'countryCode',
			flex: 1,
			sortable: true
		},{
			header:  getEnquiryTranslation('ADDRESS_MOBILE_NO'),
			dataIndex: 'mobileNo',
			flex:1,
			sortable:true
		},
		{
			header: getCommonTranslation('SUBMISSION_DATE'),
			dataIndex: 'submissionDate',
			flex: 1,
			sortable: true,
			renderer:function(date) {
				return dateRender(date);
			}
		}]
});


