/*
 *@author Deepak S
 * 
 */
Ext.define('Academia.view.campaignnew.CampaignNewFormLayout', {
	//extend:'Academia.view.common.DynamicFieldForm',
	extend: 'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.campaignnewformlayout',
    customFieldEntity:CONSTANTS.CAMPAIGN_NEW_CUSTOM_DATA,
    //bodyPadding:'10 10 10 10',
    formCode:'CampaignNewFormLayout',
    autoScroll: false,
    frame: true,
    layout: 'anchor',
    cls:'horizontalScrollingFixed x-form-fixed-footer-parent', 
    itemId: 'campaignnewform',
    title: getCampaignTranslation('DETAILS_TAB'),
    plugins: "formlabelrequired",
    method: 'POST',    
    standardSubmit: false,
    items: [{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'hidden',
			itemId:'idItemId',
			name: 'id'
		},{
			  xtype: 'textfield',
	          name: 'code',
	          itemId: 'code',
	          typeAhead:true,
	     	  minValue:0,
	     	  maxLength: 20,
	          fieldLabel: getCommonTranslation('BUZZ_CAMPAIGN_CODE')
	      //    allowBlank: false
		}, {
			xtype: 'customcombobox',
			name: 'campaignType',
			itemId: 'campaignTypeId',
			fieldLabel: getCommonTranslation('CAMPAIGN_TYPE'),
			store: 'campaignnew.CampaignTypeStore',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			forceSelection: true,
			emptyText: getCommonTranslation('SELECT'),
			allowBlank: false
		},{
			xtype: 'customcombobox',
			name: 'presentationType',
			itemId: 'presentationTypeId',
			fieldLabel: getCommonTranslation('PRESENTATION_TYPE'),
			store: 'campaignnew.PresentationTypeStore',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			forceSelection: true,
			disabled:true,
			emptyText: getCommonTranslation('SELECT'),
			allowBlank: false
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			hidden:true,
			itemId:'preSubTypeFld',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'presentationSubType',
				itemId: 'presentationSubTypeId',
				fieldLabel: getCommonTranslation('PRESENTATION_SUB_TYPE'),
				store: 'campaignnew.PresentationSubTypeStore',
				valueField: 'id',
				displayField: 'value',
				emptyText: getCommonTranslation('SELECT'),
				editable: false,
				forceSelection: true
			},{
				xtype : 'textfield',
				name : 'presentationSubTypeName',
				itemId:'presentationSubTypeNameId',
				fieldLabel : getCommonTranslation("PRESENTATION_SUB_TYPE_NAME"),
				allowBlank:true,
				editable: false,
				hidden:true,
				maxLength: 60
			}]

		}]

	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'intakeYear',
			itemId: 'intakeYearId',
			fieldLabel: getCommonTranslation('INTAKE_YEAR'),
			store: Ext.create('Academia.store.common.IntakeYearStore'),
			valueField: 'id',
			displayField: 'value',
			emptyText: getCommonTranslation('SELECT'),
			editable: false,
			forceSelection: true,
			allowBlank: false
		}, {
			xtype: 'customcombobox',
			name: 'modeOfDeliveryCSM',
			itemId: 'modeDeliveryId',
			fieldLabel: getCommonTranslation('MODE_OF_DELIVERY'),
			store: 'common.ModeOfDeliveryStore',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			forceSelection: true,
			allowBlank: false
		},{
			xtype: 'customcombobox',
			name: 'registrationType',
			itemId: 'registrationTypeId',
			fieldLabel: getCommonTranslation('REGISTRATION_TYPE'),
			store: 'campaignnew.RegistrationTypeStore',
			valueField: 'id',
			displayField: 'value',
			emptyText: getCommonTranslation('SELECT'),
			editable: false,
			forceSelection: true,
			allowBlank: false
		}]

	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'brandCampus',
			itemId: 'brandCampusId',
			fieldLabel: getCommonTranslation("BRAND_CAMPUS"),
			valueField: 'id',
			displayField: 'value',
			store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
  			minChars:3,
  			queryParam:'qry',
  			width : 462,
  			typeAhead:false,
  			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
  			enableKeyEvents  : 'true',
  			hideTrigger:false,
  			allowBlank:false,
  			forceSelection:true,
  			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
  			listConfig: {
  				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
  				loadingText: getCommonTranslation('SEARCHING'),
  				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
  				getInnerTpl: function() {
  					return '<div class="search-item">' +
  					'{value}' +
  					'</div>';
  				}
  			}
		},{
            xtype: 'multiselectcombofield',
            name: 'multiBrandCampus',
            itemId: 'multiBrandCampusId',
            fieldLabel: getCommonTranslation('BRAND_CAMPUS'),
            valueField: 'id',
			displayField: 'value',
			store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
  			//minChars:3,
  			hidden:true,
  			//queryParam:'qry',
  			cls:'multiBrandCampusCls',
  			width : 462,
  			maxHeight:125,
  			typeAhead: true,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{code}' +
                        '</div>';
                }
            }
		}, {
			xtype: 'customcombobox',
			name: 'owner',
			itemId: 'ownerId',
			fieldLabel: getCommonTranslation("OWNER"),
			store : 'resourceutilization.ActiveUserStore',
			displayField : 'valueCode',
			valueField : 'id',
			queryParam:'name',
  			minChars:3,
  			typeAhead:false,
  			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
  			enableKeyEvents  : 'true',
  			hideTrigger:false,
  			allowBlank:false,
  			forceSelection:true,
  			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			maxLength:100,
  			listConfig: {
  				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
  				loadingText: getCommonTranslation('SEARCHING'),
  				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
  				getInnerTpl: function() {
  					return '<div class="search-item">' +
  					'{value}' +
  					'</div>';
  				}
  			}
		}]

	},{
		xtype : 'fieldcontainer',
		width : '100%',
		itemId:'schoolPriorityFld',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'school',
			itemId: 'schoolId',
			fieldLabel: getCommonTranslation("SCHOOL"),
			valueField: 'id',
			displayField: 'value',
			store: 'campaignnew.CampaignSchoolStore',
  			queryParam:'schoolName',
  			minChars:3,
  			width : 462,
  			typeAhead:false,
  			disabled:true,
  			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
  			enableKeyEvents  : 'true',
  			hideTrigger:false,
  			allowBlank:false,
  			forceSelection:true,
  			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			maxLength:100,
  			listConfig: {
  				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
  				loadingText: getCommonTranslation('SEARCHING'),
  				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
  				getInnerTpl: function() {
  					return '<div class="search-item">' +
  					'{value}' +
  					'</div>';
  				}
  			}
		},{
			xtype: 'customcombobox',
			name: 'schoolPriority',
			itemId: 'schoolPriorityId',
			fieldLabel: getCommonTranslation('SCHOOL_PRIORITY'),
			store: 'campaignnew.SchoolPriorityStore',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			forceSelection: true,
			readOnly:true,
			emptyText: getCommonTranslation('SELECT'),
			allowBlank: false
		}]

	},{
		xtype : 'fieldcontainer',
		width : '100%',
		hidden:true,
		itemId:'selectSchoolFld1',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'school1',
			itemId: 'schoolId1',
			fieldLabel: getCommonTranslation("SCHOOL"),
			valueField: 'id',
			displayField: 'value',
			store: 'campaignnew.CampaignSchoolStore',
			queryParam:'schoolName',
			minChars:3,
			width : 462,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			allowBlank:true,
			disabled:true,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			maxLength:100,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'textfield',
			name:'venue',
			itemId: 'venueId',
			hidden:true,
			maxLength : 100,
			allowBlank:true,
			fieldLabel: getCommonTranslation('VENUE')
		}]
	},{
		xtype : 'fieldcontainer',
		//width : '100%',
		hidden:true,
		height:170,
		itemId:'selectPriorityFld1',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
            xtype: 'linkedtagfield',
            name: 'selectedSchool',
            itemId: 'selectedSchoolId',
            fieldLabel: getCommonTranslation('SELECTED_SCHOOL'),
            valueField: 'id',
			displayField: 'value',
			store: Ext.create('Academia.store.campaignnew.CampaignNewUserALStore'),
			editable: false,
  			width : 462,
  			height:150,
  			cls:'multiBrandCampusCls',
  			maxHeight:125,
  			maxItems: 5000,
  			enableKeyEvents:true,
			trigger1Cls: 'x-form-clear-trigger',
			trigger2Cls: '',
			onTrigger1Click: function() { 
				this.clearValue();
				this.valueStore.removeAll();
				this.next().reset();

			},
			hideTrigger: false,
        	winGridPageSize: 10,
        	moreWindowTitle: '',
        	showAllInWindow: false,
  			//readOnly:true,
  			queryMode:'local',
  			typeAhead: false,
  			padding:'15px 0px 15px 0px',
			allowBlank: true
		},{
            xtype: 'multiselectcombofield',
            name: 'schoolPriority1',
            itemId: 'schoolPriority1Id',
            fieldLabel: getCommonTranslation('SCHOOL_PRIORITY'),
			store: 'campaignnew.SchoolPriorityStore',
            displayField: 'value',
            valueField: 'id',
            allowBlank: true,
            minChars: 3,
            cls:'multiBrandCampusCls',
            height:150,
            maxHeight:125,
            typeAhead: true,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            padding:'15px 0px 15px 0px',
            hideTrigger: false,
            readOnly:true,
            forceSelection: true,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{code}' +
                        '</div>';
                }
            }
        
		}]

	}/*{
		xtype: 'fieldcontainer',
		layout : {
			type : 'vbox'
		},
		width: '100%',
		hidden:true,
		itemId:'selectPriorityFld1',
		items: []
	}*/,{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'datefield',
			name: 'startDate',
			itemId:'startDateId',
			endDateField:'endDateId',
			vtype: 'daterange',
			editable: false,
			fieldLabel:getExaminationTranslation('START_DATE'),
			allowBlank: false,
			listeners: {
				render: function(obj) {
					return dateFormatRender(obj);					
				}
			}
		},{
			xtype: 'datefield',
			name: 'endDate',
			itemId:'endDateId',
			startDateField:'startDateId',
			vtype: 'daterange',
			editable: false,
			fieldLabel:getProgramandcourseTranslation('END_DATE'),
			allowBlank: false,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},{
			xtype : 'textfield',
			name : 'campaignNumber',
			itemId:'campaignNumber',
			allowBlank: false,
			enableKeyEvents: true,
			hidden:true,
			fieldLabel : getCommonTranslation("CAMPAIGN_NUMBER"),
			maxLength: 50
		},{
			xtype : 'textfield',
			name : 'numberofCampaign',
			itemId:'noCampaignId',
			allowBlank: true,
			hidden:true,
			fieldLabel : getCommonTranslation("NUMBER_OF_CAMPAIGN"),
			maxLength: 50
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'textfield',
			name : 'campaignName',
			itemId:'campaignNameId',
			fieldLabel : getCommonTranslation("CAMPAIGN_NAME"),
			allowBlank:false,
			editable: false,
			width : 462,
			maxLength: 500
		},{
			xtype: 'numberfield',
			name: 'numberOfleadsTargeted',
			itemId: 'numberOfLeadId',
			fieldLabel: getCommonTranslation('NUMBER_OF_LEADS_TARGETED'),
			allowBlank: false,
			hideTrigger: true,
			mouseWheelEnabled:false,
			maxLength: 5,
			//enforceMaxLength : true,
			minValue:0,
			keyNavEnabled: false,
			allowDecimals: false
		}]

	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'datefield',
			name: 'createdOn',
			itemId:'createdOnId',
			fieldLabel:getCommonTranslation('CREATED_ON'),
			allowBlank: false,
			listeners: {
				render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());						
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'status',
			itemId: 'statusId',
			fieldLabel: getCommonTranslation('STATUS'),
			store: 'campaignnew.CampaignStatusStore',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			triggerAction: 'all',
			emptyText: getCommonTranslation('SELECT'),
			forceSelection: true,
			allowBlank: false
		}]

	},{
		xtype : 'fieldcontainer',
		width : '100%',
		itemId:'contactDetailFld',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'textfield',
			name : 'contactPersonName',
			itemId:'contactPersonNameId',
			fieldLabel : getCommonTranslation("CONTACT_PERSON_NAME"),
			maxLength: 55
		},{
			xtype : 'textfield',
			name : 'emailAddress',
			itemId:'emailAddressId',
			vtype: 'email',
			fieldLabel : getAdmissionTranslation("EMAIL_ADDRESS"),
			maxLength: 100
		},{
			xtype:'fieldcontainer',
			labelSeparator : ':',
			fieldLabel: getAdmissionTranslation('MOBILE_NO'),
			itemId:'mobileNoContainer',
			layout:'hbox',
			labelAlign:'top',
			items:[{
				xtype: 'customcombobox',
				valueField: 'isdCode',
				displayField: 'isdCode',
				store: Ext.create('Academia.store.common.CountryStore'),
				itemId:'mobileCountryCodeId',
				name: 'mobileCountryCode',
				width: 80,
				forceSelection:true,
				emptyText: 'Code', 
				minChars: 1
			},{
				xtype: 'numberfield',
				name:'mobileNo',
				itemId:'mobileNumberId',
				minLength: 0,
				maxLength: 11,
				spinUpEnabled : false,
				spinDownEnabled : false,
				hideTrigger : true,
				enforceMaxLength : true,
				width:150
			}]
		}]

	},{
		xtype : 'fieldcontainer',
		width : '100%',
		hidden:true,
		itemId:'advertURLFld',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'textfield',
			name : 'advertisementURL',
			itemId:'advertURLId',
			fieldLabel : getCommonTranslation("ADVERT_URL"),
			width : 462,
			maxLength: 255
		}]

	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype:'displayfield',
			value:'<b class="menu-title">'+getServiceRequestTranslation('FD_UPLOAD_DOCUMENT')+'</b>',
			style: {
				textDecoration: "underline"
			}
		}]
	},{
    	xtype: 'fieldcontainer',
    	/*style:{
    		marginTop: '0px',
    		marginLeft: '20px'
    	},*/
    	defaults: {
    		width: 256,
    		labelAlign: 'top'
    	},
    	items: [{
    		xtype:'meetingdocumentgrid',
    		itemId:'documentsGridCampaignNew',
            minHeight: 0,
            cls: 'no-empty-placeholder-grid',
            isFixHeightGrid: true,
            isFixWidthColums: true,
    		style:{
    			marginBottom: '10px !important',
    			marginLeft:'0px !important'
    		}
    	},{
    		xtype: 'button',
    		name: 'meetingDocsCampaign',
    		text:getCommonTranslation('UPLOAD_DOC'),
    		itemId: 'meetingDocsCampaignId',
    		ui: 'CustomBtnCancel',
    		cls:'no-icon-btn',
    		scale : CONSTANTS.BUTTONSIZE
    	}]
    }/*{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
            xtype: 'filefield',
            itemId: 'uploadFileField',
            region: 'south',
            ui: 'CustomBtnSubmit',
            fieldLabel: getCommonTranslation('UPLOAD_FILE'),
            buttonText: getPersonModuleTranslation('UPLOAD'),
            name: 'file',
            listeners: {
                change: function(fileField, value) {
                    value = value.replace('C:\\fakepath\\', '');
                    fileField.setRawValue(value);
                }
            }
        }]

	}*/,{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'textarea',
			name:'remarks',
			width: 462,
			maxLength : 1000,
			fieldLabel: getCommonTranslation('REMARKS')
		}]

	}, {
		xtype:'fieldcontainer',
    	cls: 'form-fixed-footer',
    	width:'auto',
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
    		xtype: 'button',
    		itemId: 'btnSaveCampaignNewForm',
    		text: getCommonTranslation('SAVE'), //Save
    		ui: 'CustomBtnSubmit',
    		formBind: true,
    		scale: CONSTANTS.BUTTONSIZE
    	},{
    		xtype: 'button',
    		text: getExaminationTranslation('RESET'),
    		itemId: 'campaignResetButtonId',
    		ui: 'CustomBtnCancel',
    		scale: CONSTANTS.BUTTONSIZE
    	}]
    }]
});
