/**
 * @author Amit G
 */
Ext.define('Academia.view.campaignnew.EnquiryCampaignDownloadForm', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.enquirycampaigndownloadform',
    frame: false,
    method: 'POST',
    standardSubmit: false,
    items: [{
        xtype: 'fieldcontainer',
        items: [{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top'
            },
            items: [{
    			xtype: 'customcombobox',
    			name: 'campaignName',
    			itemId: 'campaignNameId',
    			fieldLabel : getCommonTranslation("CAMPAIGN_NAME"),
    			valueField: 'id',
    			displayField: 'value',
    			store: Ext.create('Academia.store.campaignnew.CampaignNameFilterStore'),
    			queryParam:'campaignName',
    			minChars:3,
    			width : 280,
    			maxLength:500,
    			typeAhead:false,
    			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    			enableKeyEvents  : 'true',
    			hideTrigger:false,
    			forceSelection:true,
    			allowBlank: true,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			triggerAction: '',
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    						picker.width = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			}
    		}]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top'
            },
            items: [{
                xtype: 'multiselectcombofield',
                width: 536,
                name: 'academyLocation',
                itemId: 'academyLocationItemId',
                fieldLabel: getProgramandcourseTranslation('ACADEMY_LOCATION'),
                store: 'common.AcademyLocationNameSeparated',
                allowBlank: false,
                valueField: 'id',
                //maxLength: 4000,
                displayField: 'value'
            }]
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        width:'auto',
        style:{
			'margin-left':'-32px !important'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
            itemId: 'downloadEnquiryNewFormItemId',
            hidden: false,
            formBind: true,
            ui: 'CustomBtnSubmit'
        }, {
            xtype: 'button',
            text: getCourseTxCommonTranslation('RESET'),
            itemId: 'resetBtn',
            //buttonAlign: 'left',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});