
/**
 * @author Pankaj Sisodiya
 */
Ext.define('Academia.view.committee.committee.BulkCommitteeParticipantUploadForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.bulkCommitteeParticipantUploadForm',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	cls:'customSearchInnerPanel',
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	items: [{
		xtype:'committeeuploadoptionradiogroup',
		width: 500,
        margin: 0,
		itemId:'bulkCommitteeParticipantRadioGroupItemId',
	},{
		xtype: 'customcombobox',
		name: 'importUtilityMasterId',
		itemId:'moduleName',
		store:'importutility.ModuleName',
		fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
		valueField: 'id',
		displayField: 'value',
		typeAhead:true,
		forceSelection:true,
		allowBlank:false,
		readOnly:true
	},{
		xtype : 'filefield',
		ui : 'CustomBtnThird',
		width: 536,
		fieldLabel : getCommonTranslation('UPLOAD_FILE'),
		buttonText : getCommonTranslation('BROWSE_FILE'),
		itemId : 'uploadFileField',
		name : 'file',
		allowBlank:false,
		validateOnChange : true,
		listeners:{
            change: function(fileField, value) {
                value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
                    if (!baseController.isValidFileExtensionForLoader(extension)) {
                        fileField.reset();
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
                    }
                }
            }
        }
	},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getTranslation('UPLOAD_DATA'),
			formBind: true,
			itemId: 'bulkCommitteeParticipantBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			margin: '0 32 0 0'
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'resetBtn',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]});
