/**
 * @author Deepak Sharma
 * 
 */
Ext.define('Academia.view.committee.committee.CommitteApplyToGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.committeapplytogrid',
	store : 'committee.committee.CommitteeApplyToGridStore',
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'committee.committee.CommitteeApplyToGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns : [{
		header:  getProgramandcourseTranslation("ACADEMY_LOCATION"),
		dataIndex: 'academyLocationName',
		flex:1
	},{
		header : getCommonTranslation('PROGRAM_GROUP_NAME'),
		dataIndex : 'programGroupName',
		flex:1
	},{
		header : getProgramandcourseTranslation('PROGRAM_NAME'),
		dataIndex : 'programName',
		flex:1
	},{
		header : getProgramandcourseTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getAdmissionTranslation('SEAT_TYPE'),
		dataIndex : 'seatTypeName',
		flex:1
	}]
});
