/**
 * @author bhanu pratap singh
 */
Ext.define('Academia.view.committee.committee.CommitteeALWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.committeealwindow',
	title:getCommonTranslation("COMMITTEE_ACADEMY_LOCATION"),
	modal: true,
	autoScroll:true,
	width: '30%',
	height:'50%',
	//height:'50%',
	items: [{
		xtype: 'form',
		method: 'POST',
		itemId:'academyLocationForm',
		hidden:true,
		margin: 0,
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype:'hidden',
			itemId:'id',
			name:'id'
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			style:{
				marginLeft:'15px'
			},
			defaults :{
				width: 536,
				labelAlign: 'top',
			},
			items: [{
				xtype:'displayfield',
				name:'committeeName',
				itemId:'committeeNameAL',
				labelAlign: 'top',
				fieldLabel:getCommonTranslation("COMMITTEE_CODE")
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 536
			},
			items: [{
				xtype: 'committeealgrid',
				name:'academyLocationGrid',
				itemId:'academyLocationGridItemId',
			}]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			items: [{
	            xtype: 'button',
	            text: getServiceRequestTranslation('CANCEL'),
	            ui: 'CustomBtnCancel',
	            itemId: 'cancelButtonId',
	            scale: CONSTANTS.BUTTONSIZE,
	            handler :function(button) {
	            	button.up('window').close();
	            }
	        }]
		}]
	},{
		xtype: 'form',
		method: 'POST',
		itemId:'descriptionForm',
		hidden:true,
		margin: 0,
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			style:{
//				marginLeft:'15px'
			},
			defaults :{
				width: 536,
			},
			items: [{
				xtype:'displayfield',
				name:'committeeName',
				itemId:'committeeNameDesc',
				labelAlign: 'top',
				fieldLabel:getCommonTranslation("COMMITTEE_CODE")
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 536
			},
			items: [{
				xtype: 'textarea',
				name:'description',
				itemId:'description',
				//maxLength : 250,
				fieldLabel: getExaminationTranslation('Description')
			}]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			items: [{
	            xtype: 'button',
	            text: getServiceRequestTranslation('CANCEL'),
	            ui: 'CustomBtnCancel',
	            itemId: 'cancelButtonId',
	            scale: CONSTANTS.BUTTONSIZE,
	            handler :function(button) {
	            	button.up('window').close();
	            }
	        }]
		}]
	},{
		xtype: 'form',
		method: 'POST',
		itemId:'mapCommitteeWindowId',
		hidden:true,
		margin: 0,
		defaults: {
			labelAlign: 'top',
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			defaults: {
				labelAlign: 'top',
				width: 256,
			},
			
			defaults: {
				labelAlign: 'top',
				width: 256,
			},
			items: [{
				xtype: 'customcombobox',
				name: 'committee',
				itemId:'committeeItemId',
				store:'committee.committee.CommitteeStore',
				queryParam:'name',
				displayField:'valueCode',
				valueField:'id',
				labelAlign: 'top',
				width: 270,
				forceSelection:true,
				allowBlank:false,
				typeAhead:true,
				fieldLabel:getCommonTranslation("COMMITTEE_CODE_NAME"),
				matchFieldWidth:true,
				listeners: {
					change: function(object) {
						object.up().up().isValid();
					}
				}/*,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							var comboElm = picker.up('combobox'),
							comboWidth = comboElm.getSize().width,
							labelWidth = comboElm.getLabelWidth();
							picker.minWidth = comboWidth - labelWidth;
						}
					}
				}*/
			}]
		},{
			xtype: 'fieldcontainer',    
			width:'auto',
			items : [{
				xtype : 'button',
				text : getCommonTranslation("SAVE") ,
				itemId : 'submitBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
                xtype: 'button',
                text: getServiceRequestTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE,
                handler :function(button) {
                	button.up('window').close();
                }
            }]
		}]
	},{
		xtype: 'form',
		method: 'POST',
		itemId:'mapCommitteeParticipantWindowId',
		hidden:true,
		margin: 0,
		defaults: {
			labelAlign: 'top',
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'customcombobox',
				name: 'userType',
				itemId: 'userType',
				fieldLabel: getFileManagementTranslation('USER_TYPE'),
				editable: false,
				disableKeyFilter: false,
				valueField: 'id',
				allowBlank:false,
				displayField: 'userGroupName',
				store: 'attendance.UserGroup'
			},{
				xtype: 'customcombobox',
				name:'assignedUser',
				itemId:'assignedUser',
				fieldLabel : getFileManagementTranslation('USER'),
				msgTarget: 'qtip',
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'codeOrName',
				minChars:3,
				disabled:true,
				allowBlank:false,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listeners:{
					render : function(combo){
						var store=Ext.create('Academia.store.committee.committee.CommitteeParticipantUserComboStore');
						combo.bindStore(store)
					}
				},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'textfield',   //duplicate records are not allowed that's why on edit api was not returning grid data
				name:'assignedUserForEditCase',
				itemId:'assignedUserForEditCase',
				fieldLabel : getFileManagementTranslation('USER'),
				hidden:true,
				labelSeparator:'',
			},{
				xtype:'hidden',
				name:'assignedUserIdForEdit',
				itemId:'assignedUserIdForEdit'
			}]
		},{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'textfield',
				name:'designationName',
				itemId:'designationNameItemId',
				fieldLabel:getCommonTranslation('DESIGNATION_NAME'),
				maxLength: 50
			},{
				    xtype: 'textfield',
		            name:'responsability',
		            itemId:'responsabilityItemId',
		            fieldLabel:getCommonTranslation('COMMITTEE_PARTICIPANT_RESPONSABILITY'),
		            maxLength: 250
			}]
		},{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'datefield',
				endDateField:'toDateItemId',
				vtype: 'daterange',
				fieldLabel:getExaminationTranslation('FROM_DATE'),
				name: 'fromDate',
				itemId:'fromDateItemId',
				vtype: 'daterange',
				endDateField:'toDateItemId',
				editable:false,
				//--submitFormat:CONSTANTS.DATE_FORMAT,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},{
				xtype: 'datefield',
				name: 'toDate',
				itemId:'toDateItemId',
				startDateField: 'fromDateItemId',
				vtype: 'daterange',
				editable:false,
				//--submitFormat:CONSTANTS.DATE_FORMAT,
				fieldLabel:getExaminationTranslation('TILL_DATE'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		},{    
			xtype:'fieldcontainer',
			itemId:'membershipContainerPanelId',
			items:[{
				xtype: 'fieldcontainer',
				itemId:'membershipContainer',
				layout : 'hbox',
				hidden:true,
				defaults: {
					labelAlign: 'top',
					width: 256
				},
					items: [{
		            xtype: 'customcombobox',
		            name: 'membershipTypeUser',
		            itemId: 'membershipTypeUser',
		            fieldLabel: getCommonTranslation("MEMBERSHIP_TYPE"),
		            store: Ext.create('Academia.store.committee.committee.MembershipTypesStore'),
		            valueField: 'id',
		            displayField: 'value',
		            matchFieldWidth:true,
		            editable: false
		        },{
		            xtype: 'customcombobox',
		            name: 'additionalMembershipType',
		            itemId: 'additionalMembershipType',
		            fieldLabel: getCommonTranslation("ADDITIONAL_MEMBERSHIP"),
		            store: Ext.create('Academia.store.committee.committee.MembershipTypesStore'),
		            valueField: 'id',
		            displayField: 'value',
		            matchFieldWidth:true,
		            editable: false
		        },{
	        		xtype : 'button',
	        		itemId: 'btnAdditionalMemebership',
	        		cls: 'CustomBodyBtnSettings',
					text: getCommonTranslation('ADDBUTTONTEXT'),
					tooltip: getCommonTranslation('ADD'),
					disabled:true,
					style:{
						marginTop:'30px'
					}
	        	}]
			}]
		},{
			xtype: 'fieldcontainer',    
			width:'100%',
			items : [{
				xtype : 'button',
				text : getCommonTranslation('SAVE'),
				itemId : 'submitCommitteeParticipantBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
                xtype: 'button',
                text: getServiceRequestTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE,
                handler :function(button) {
                	button.up('window').close();
                }
            }]
		}]
	}],
	
    persistCommitteeMaping: function(button, grid) {
    	baseController = Academia.app.getController('Academia.controller.base.BaseController');
		var formData = button.up('form').getValues();
    	var json=[];
    	var record = grid.getSelectionModel().getSelection();
    	for(var i in record){
    		var committee={
    				"id":formData.committee
    		};
    		var participant={
    				"id":record[i].data.ID
    		};
    		json.push({
    			"committee":committee,
    			"participant":participant
    		})
    	}
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	var	submitUrl=SERVERURL.COMMITTEE_PARTICIPANT_CREATE;
    	Ext.Ajax.request({
    		type : 'rest',
    		url : submitUrl,
    		jsonData : json,
    		method : 'POST',
    		success : function(form, action) {
    			Ext.getBody().unmask();
    			showSuccessMessage(getCommonTranslation("COMMITTEE"),getCommonTranslation('SUCCESS'));
    			button.up().up().up().close();
    		}
    	});
    }
});