/**
 *  @author priyanshi Sharma
 */

Ext.define('Academia.view.committee.committee.CommitteeAddMappingATProgramBatchPeriodGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.committeeaddmappingatprogrambatchperiodgrid',
	title : getCommonTranslation('PERIOD'),
	store: Ext.create('Academia.store.committee.committee.CommitteeATProgramBatchPeriodStore'),
	selType:'checkboxmodel',
	//cls:'removeGridHorizontalScrollCls',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: false,
	height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false,
		deferEmptyText: false,
		emptyText: getCommonTranslation('NORESULTSNMESSAGE')
	},
	border: true,
	tbar: [{
		xtype: 'button',
		text: getCommonTranslation('SUBMITKYS'),
		itemId: 'submitMapping',
		buttonAlign: 'left',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'customcombobox',
		name: 'prgramBPsearchcombo',
		itemId:'prgramBPsearchcombo',
		valueField: 'id',
		displayField: 'periodName',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'periodQry',
		queryMode: 'remote',
		width: 256,
		store: 'committee.committee.CommitteeATProgramBatchPeriodComboStore',
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		}
	}],
	columns: [{
		header : getCommonTranslation('ACADEMIC_TERM'),
		dataIndex : 'academicTermName',
		flex : 1	 
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1	 
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1	 
	},{
		header : getCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex : 1	 
	}]
});