/**
 * @author Vishal Joshi
 * 
 */
Ext.define('Academia.view.committee.committee.StudentCommitteeFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.studentcommitteefilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'committee',
			itemId:'committeeItemId',
			store:'committee.committee.StudentCommitteeStore',
			displayField:'valueCode',
			valueField:'id',
			queryParam:'nameOrCode',
			typeAhead:false,
			minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			},
			fieldLabel:getCommonTranslation("COMMITTEE_CODE_NAME")
		}
		,{
			xtype: 'customcombobox',
			name: 'status',
			itemId:'statusItemId',
			store:'common.StatusComboStore',
			displayField:'name',
			valueField:'id',
			value:'ACTIVE',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			fieldLabel:getCommonTranslation('STATUS'),
			/*listeners: {
				render: function(object) {
					object.getStore().load({
						callback:function(record) {
							object.setValue(record[0].data.id);
						}
					});
				}
			}*/
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation("SEARCH"),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation("RESET"),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]

});
