/**
 * @author Rohit Thadani
 * 
 */
Ext.define('Academia.view.committee.committee.StudentCommitteeForm',{
	extend:'Academia.view.common.DynamicFieldForm',
	alias : 'widget.studentcommitteeform',
	autoScroll: true,
	bodyPadding:'10 10 10 10',
	frame:true,
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	method: 'POST',
	defaults: {
		labelAlign: 'top',
	},
	plugins : "formlabelrequired",
	items : [{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'hidden',
			itemId:'idItemId',
			name: 'id'
		}, {
			xtype : 'textfield',
			name : 'committeeCode',
			itemId:'committeeCodeItemId',
			fieldLabel : getCommonTranslation("COMMITTEE_CODE"),
			allowBlank:false,
			maxLength: 10
		},{
			xtype : 'textfield',
			name : 'committeeName',
			itemId:'committeeNameItemId',
			fieldLabel : getCommonTranslation("COMMITTEE_NAME"),
			allowBlank:false,
			maxLength: 45
		}]

	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'multiselectcombofield',
			width: 536,
			name: 'multiselectAcademyLocation',
			itemId: 'multiselectAcademyLocationId',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:'user.UserAcademyLocationStore',
			cls:'multiBrandCampusCls',
			displayField:'value',
			valueField:'id',
			triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
			maxLength:15000,
			autoloadStore: false,
			allowBlank:false,
			height:'10px'
		},{
			xtype: 'customcombobox',
			name: 'user',
			itemId: 'userItemId',
			fieldLabel: getCommonTranslation("COMMITTEE_CO_ORDINATOR"),
			valueField: 'id',
			displayField: 'value',
			store: 'transport.serviceRoute.InternalUser',
  			queryParam:'codeOrName',
  			minChars:3,
  			typeAhead:false,
  			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
  			enableKeyEvents  : 'true',
  			hideTrigger:false,
  			allowBlank:false,
  			forceSelection:true,
  			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			maxLength:100,
  			listConfig: {
  				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
  				loadingText: getCommonTranslation('SEARCHING'),
  				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
  				getInnerTpl: function() {
  					return '<div class="search-item">' +
  					'{value}' +
  					'</div>';
  				}
  			},
  			disabled:true
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		style:{
			marginTop:'22px',
			marginBottom:'15px'
		},
		defaults : {
			labelAlign : 'top'
		},
		items : [ {
			html: '<b><u>Validity</u></b>',
			margin: 0,
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'datefield',
			name: 'fromDate',
			itemId:'fromDateItemId',
			endDateField:'toDateItemId',
			vtype: 'daterange',
//			value:new Date(),
			//--submitFormat: CONSTANTS.DATE_FORMAT,
			fieldLabel:getExaminationTranslation('FROM_DATE'),
			listeners: {
				render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());
				}
			}
		},{
			xtype: 'datefield',
			name: 'toDate',
			itemId:'toDateItemId',
			//--submitFormat: CONSTANTS.DATE_FORMAT,
			fieldLabel:getCommonTranslation('TO_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'status',
			itemId:'statusItemId',
			store:'common.StatusComboStore',
			displayField:'name',
			valueField:'id',
			value:'ACTIVE',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			fieldLabel:getCommonTranslation('STATUS'),
			/*listeners: {
				render: function(object) {
					object.getStore().load({
						callback:function(record) {
							object.setValue(record[0].data.id);
						}
					});
				}
			}*/
		}]
	},{
		xtype: 'fieldcontainer',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 536,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'textarea',
			name:'description',
			width: 536,
			maxLength : 255,
			fieldLabel: getExaminationTranslation('Description')
		}]
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'hbox'
		},
		width:'auto',
		items : [{
			xtype : 'button',
			text : getCommonTranslation("SAVE") ,
			itemId : 'submitBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation("RESET"),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
			/*listeners: {
				click: function(object) {
					var form = object.up('form').getForm();
					form.findField('user').reset();
					form.reset();
				}
			}*/
		}]
	}]
});
