/**
 * @author Amit G
 *  basic Details Panel 
 */
Ext.define('Academia.view.committee.committee.StudentCommitteeRequestBasicDetails', {
    extend: 'Ext.form.Panel',
    alias: 'widget.studentcommitteerequestbasicdetails',
    items: [{
        xtype: 'hidden',
        name: 'requestAssignedToId',
        itemId: 'requestAssignedToItemId',
        hidden: true
    },{
        xtype: 'hidden',
        name: 'requestAssignedToUserId',
        itemId: 'requestAssignedToUserItemId',
        hidden: true
    },{
        xtype: 'fieldset',
        title: getCommonTranslation('BASIC_DETAILS'),
        collapsed: false,
        items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
                labelAlign: 'top',
                width: 256
        },
        items: [{
        xtype: 'displayfield',
        itemId: 'enteredBy',
        fieldLabel: getCommonTranslation('ENTERED_BY'),
        name: 'enteredBy',
        width:300
    }, {
        xtype: 'displayfield',
        itemId: 'assignedTo',
        fieldLabel: getCommonTranslation('REQUEST_ASSIGNED_TO'),
        name: 'requestAssignedTo',
        width:300
    }]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
        xtype: 'datefield',
        fieldLabel: getCommonTranslation('REQUEST_DATE'),
        name: 'requestDate',
        itemId: 'requestDate',
        listeners: {
        	render: function(field) {
        		field = dateFormatRender(field);						
				field.setValue(new Date());
        	}
        },
        allowBlank: false,
        readOnly:true
      },{
          xtype: 'customcombobox',
          fieldLabel: getCommonTranslation('COMMITTEE_NAME'),
          name: 'committeeId',
          itemId: 'committeeNameItemId',
          store:'committee.committee.StudentApplyForCommitteeStore',
          valueField: 'id',
          displayField: 'value', 
          allowBlank: false,
          editable: false,
          querymode: 'local'
      }]
    },
    {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
          xtype: 'customcombobox',
          fieldLabel: getCommonTranslation('MEMBERSHIP_TYPE'),
          name: 'membershipType',
          itemId: 'membershipTypeItemId',
          store:'committee.committee.CommitteeMemberShipTypeByCommitteeIdStore',
          valueField: 'id',
          displayField: 'value',
          disabled:true,
          allowBlank: false,
          editable: false,
          querymode: 'local'
      },{
          xtype: 'textfield',
          fieldLabel: getCommonTranslation('MEMBERSHIP_AMOUNT'),
          name: 'membershipAmount',
          itemId: 'membershipAmountItemId',
          disabled:true,
          readOnly:true,
          allowBlank: true,
          editable: false
      }]
    },{
        xtype: 'fieldcontainer',
        layout: {
            type: 'vbox'
        },
        defaults: {
            width: 536,
            labelAlign: 'top'
        },
        items: [{
        xtype: 'textareafield',
        fieldLabel: getCommonTranslation('DESCRIPTION'),
        name: 'remarks',
        itemId: 'requestReason',
        allowBlank: false,
        enforceMaxLength : true,
        maxLength : 255,
        vtype : 'NospaceAsInput',
        maxLengthText : getCommonTranslation('MAX_LENGTH_VALIDATION')
    }]
    }]
    }]
});