/**
 * This is the Academy Location Program Batch SeatType Dependent Dropdown Component.
 * Deepak S
 */
Ext.define('Academia.view.common.ALProgramBatchSeatTypeFormNew', {
    extend: 'Ext.form.Panel',
    alias: 'widget.alprogrambatchseattypeformnew',
    cls: 'customSearchInnerPanel',
    margin: 0,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 300
        },
        items: [{
            xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
            name: 'academy_location_id',
            itemId:'academy_loc_combo',
            store: 'user.UserAcademyLocationStore',
            displayField: 'value',
            valueField: 'id',
            width:452,
            allowBlank: false,
            typeAhead : true,
            forceSelection:true,
            hideTrigger:false,
            queryParam:'qry',
            //triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            //queryMode: 'local',
    	    triggerAction: 'all',
    	    //anyMatch : true,
            minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listeners: {
                select: function(combo, records, eOpts) {
                	var form = combo.up('form');
                	form.selectALCombo(form,combo);
                }
            },
            listConfig: {
            	listeners: {
            		beforeshow: function(picker) {
            			picker.minWidth = picker.up('combobox').getSize().width;
            		}
            	},
            	loadingText: getCommonTranslation('SEARCHING'),
            	emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            	getInnerTpl: function() {
            		return '<div class="search-item">' +
            		'{value}'  +
            		'</div>';
            	}
            }
        },{
        	xtype: 'nestedJsonCombo',
            name: 'program',
            itemId: 'programCombo',
            displayField: 'valueCode',
            valueField: 'id',
            //queryMode: 'local',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection:true,
            minChars:3,
            queryParam:'qry',
			typeAhead:false,
			hideTrigger:false,
            autoload: false,
            allowBlank: false,
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            listeners: {
                select: function(combo, records, eOpts) {
                	var form = combo.up('form');
                	var batchCombo = form.down('#batchCombo');
                	form.loadDependentCombo(batchCombo, records, 'id');
                },
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.ProgramsByAcademyIdLocationId');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
        	xtype: 'nestedJsonCombo',
            name: 'batch',
            itemId: 'batchCombo',
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            allowBlank: false,
            editable:false,
            disabled:true,
            fieldLabel: getCommonTranslation('BATCH'),
            listeners: {
                select: function(combo, records, eOpts) {
                	var form = combo.up('form');
                	var seatTypeCombo = form.down('#seatTypeCombo');
                	form.loadDependentCombo(seatTypeCombo, records, 'batchId');
                },
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.BatchesByProgramId');
                    combo.bindStore(store);
                }
            }
        },{
        	xtype: 'nestedJsonCombo',
            name: 'seatType',
            itemId: 'seatTypeCombo',
            displayField: 'seatTypeName',
            valueField: 'seatTypeId',
            progBatchSeatConfigId: null,
            fieldLabel: getCommonTranslation('SEAT_TYPE'),
            queryMode: 'local',
            autoload: false,
            allowBlank: false,
            editable:false,
            disabled:true,
            listeners: {
            	select: function(combo, records, eOpts) {
            		combo.progBatchSeatConfigId =records[0].get('id');
            	},
            	render: function(combo) {
                    var store = Ext.create('Academia.store.common.SeatTypesByBatchId');
                    combo.bindStore(store);
                }
            }
        }]
    }],
    
    selectALCombo: function(form,combo){
    	var programCombo = form.down('#programCombo');
    	var batchCombo = form.down('#batchCombo');
    	var seatTypeCombo = form.down('#seatTypeCombo');
		var programStore = programCombo.getStore();
		var alComboVal = combo.getValue();
		programCombo.reset();
		programStore.getProxy().extraParams = {
			academyLocationIds: alComboVal
		};
		programStore.load();
		batchCombo.reset();
		batchCombo.setDisabled(true);
		seatTypeCombo.reset();
		seatTypeCombo.setDisabled(true);
    },

    /**
     * Method to load the next combo based on the selection of the previous combo value.
     * @param {Object} dependentCombo is the reference of the next dropdown which should be populated with values.
     * @param {Object} selectedRecord is the record of the previous dropdown which is selected.
     * @param {Object} parameter is the value that should be attached in the url.
     * @param {Object} extraParameter (optional) If there is any extra parameter to be sent for loading the
     *  dependent dropdown.
     * @param {Object} extraParamValue (optional) The value of the extraParam that is sent for loading the store.
     */
    loadDependentCombo: function(dependentCombo, selectedRecord, parameter, extraParameter, extraParamValue) {
    	var me = this;
    	this.resetOtherDropdowns(dependentCombo);
        dependentCombo.clearValue();
        dependentCombo.store.removeAll();
        var store = dependentCombo.getStore();
        var id = selectedRecord[0].get('id');
        var url = store.getProxy().proxyConfig.api.read;
        if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
            url = url.concat('?' + parameter + '=' + id);
        } else {
            url = url.concat('?' + parameter + '=' + id);
            url = url.concat('&' + extraParameter + '=' + extraParamValue);
        }
        store.getProxy().api.read = url;
        store.load({
        	callback : function(record){
        		if(!isNullOrEmpty(record) && record.length == 1) {
        			if(dependentCombo.name == 'seatType' ) {
        				dependentCombo.setValue(record[0].data.seatTypeId);
        				dependentCombo.progBatchSeatConfigId = record[0].data.id;
        			} else {
        				dependentCombo.setValue(record[0].data.id);
        				me.loadDependentCombo(dependentCombo.nextSibling(),record,'batchId');
        				dependentCombo.nextSibling().setDisabled(false);
        			}
        		}
        	}
        });
    }, 
    
    /**
     * code to reset other dropdowns based on the selection of any dropdown which is previous in the hierarchy.
     * eg: if all the dropdowns are loaded and the Academy is changed then subsequent dropdowns should be
     * changed accordingly, so their value is cleared and reset and reloaded.
     * @param: {Object} combo The reference of the dropdown which is the dependent/next combo. 
     */
    resetOtherDropdowns: function(combo) {
    	var container = combo.up('form');
    	switch(combo.name) {
//    	case 'academy':
//    		break;
//    	case 'location':
//    		this.clearCombo(combo);
//    		programCombo = container.down('combo[name=program]');
//    		this.clearCombo(programCombo);
//    		batchCombo = container.down('combo[name=batch]');
//    		this.clearCombo(batchCombo);
//    		seatTypeCombo = container.down('combo[name=seatType]');
//    		this.clearCombo(seatTypeCombo);
//    		break;
    	case 'program':
    		this.clearCombo(combo);
    		batchCombo = container.down('combo[name=batch]');
    		this.clearCombo(batchCombo);
    		seatTypeCombo = container.down('combo[name=seatType]');
    		this.clearCombo(seatTypeCombo);
    		break;
    	case 'batch':
    		this.clearCombo(combo);
    		seatTypeCombo = container.down('combo[name=seatType]');
    		this.clearCombo(seatTypeCombo);
    		combo.setDisabled(false);
    		seatTypeCombo.setDisabled(true);
    		break;
    	case 'seatType':
    		this.clearCombo(combo);
    		combo.setDisabled(false);
    		break;
    	}
	},
	
	/**
	 * function to clear the combo store, clear its existing value
	 *  and remove all the records from the store.
	 *  @param {Object} the reference of the combo whose store should be cleared.
	 */
	clearCombo: function(combo) {
		combo.clearValue();
		combo.store.removeAll();
	},
	reset:function(){
		//var academyCombo =this.down('combo[name=academy]');
		//academyCombo.clearValue();
		//var locationCombo =this.down('combo[name=location]');
		this.items.items[0].resetOtherDropdowns(locationCombo);
	}
});
