/**
 * @author Rajkumar.patidar
 * 
 */
Ext.define('Academia.view.common.AddressDetailPanel', {
	extend: 'Ext.form.FormPanel',
	alias: 'widget.addressdetailpanel',
	collapsible: true,
	collapsed:true, 
	autoScroll: true,
	title:getFeeAndPaymentCommonTranslation('PERSONAL_DETAILS'),
	border: true,
	bodyCls: 'persondetailslinkpanelFont personalDetailsPanelHeightCls',
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	items: [{
		xtype:'fieldcontainer',
		layout:'vbox',
		style:{marginLeft:'10px'},
		width: 'auto',
		defaults: {
			width: 256,
			labelAlign: 'top',
			xtype: 'displayfield',
			labelStyle:'margin-top:0px !important;color:darkblue;'
		},
		items:[{
			xtype:'fieldcontainer',
			layout:'hbox',
			style:{marginLeft:'10px'},
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype: 'displayfield',
				labelStyle:'margin-top:10px !important;color:darkblue;'
		},
		items:[{
			xtype:'image',
			itemId: 'profile_image',
			border: 1,
			style: {
					marginTop: '12px !important;'
			},
				width: 90,
				height: 90
		},{
				xtype:'fieldcontainer',
				layout:'vbox',
				style:{marginLeft:'10px'},
				width: 'auto',
				defaults: {
					width: 256,
					labelAlign: 'top',
					xtype: 'displayfield',
					//labelStyle:'margin-top:10px !important;color:darkblue;',
				},
				items: [{	
					//fieldLabel:getFeeAndPaymentCommonTranslation('NAME'),
			        itemId:'name',
					name:'name',
					cls:'personalFlyOutNameCls'
				},{
					fieldLabel:getFeeAndPaymentCommonTranslation('APPLICANT_ID'),
					itemId:'applicantId',
					name:'applicantId',
					labelStyle:'margin-top:5px !important;color:darkblue;',
					width: 126,
					cls:'flyoutCommonDisplayFieldCls'
					//cls:'flyoutApplicantDisplayFieldCls'
				},{
					fieldLabel:getFeeAndPaymentCommonTranslation('APPLICATION_ID'),
					itemId:'applicationId',
					name:'applicationId',
					labelStyle:'margin-top:5px !important;color:darkblue;',
					width: 126,
					cls:'flyoutCommonDisplayFieldCls'
					//cls:'flyoutApplicantDisplayFieldCls'
				}]	
			},]
		},{
			xtype:'fieldcontainer',
			layout:'vbox',
			cls:'addressPanelFieldCls',
			//style:{marginLeft:'10px'},
			width: 292,
			
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype: 'displayfield',
				style:{marginLeft:'10px'},
				labelStyle:'margin-top:10px !important;color:darkblue;',
				cls:'flyoutCommonDisplayFieldCls'
			},
			items: [{
			fieldLabel:getFeeAndPaymentCommonTranslation('FATHER_NAME'),
			itemId:'fatherName',
				name:'fatherName',
			},{
				fieldLabel: getFeeAndPaymentCommonTranslation('ADDRESS'),
				name: 'address',
				itemId:'address',
				cls:'flyoutCommonDisplayFieldCls personalFlyOutAddressCls'
			},{
				fieldLabel:getFeeAndPaymentCommonTranslation('MOBILE_NUMBER'),
				itemId:'contactNo',
				name:'contactNo',
				cls:'personalFlyOutMobCls flyoutCommonDisplayFieldCls'
			},{
				fieldLabel: getFeeAndPaymentCommonTranslation('EMAIL'),
				name: 'emailId',
				itemId:'emailId',
				cls:'personalFlyOutEmailCls flyoutCommonDisplayFieldCls'
			}],
			listeners: {
				afterlayout: function(comp){
					var containerItems = comp.items.items;
					var contArray =[];
					Ext.each(containerItems,function(contItem){
						if(contItem.isVisible() == true){
							contArray.push(contItem);
						}
					});
					if(contArray.length == 0){
						comp.removeCls('addressPanelFieldCls');
					}else if(contArray.length > 0) {
						comp.addCls('addressPanelFieldCls');
						
					}
				}
			}
		},{
			xtype:'fieldcontainer',
			layout:'vbox',
			width: 292,
			cls:'addressPanelFieldCls',
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype: 'displayfield',
				style:{marginLeft:'10px'},
				labelStyle:'margin-top:10px !important;color:darkblue;',
				cls:'flyoutCommonDisplayFieldCls'
			},
			items: [{
				fieldLabel:getFeeAndPaymentCommonTranslation('ADMISSION_ID'),
				itemId:'addmissionId',
				name:'addmissionId'
			},{
				fieldLabel:getFeeAndPaymentCommonTranslation('PROGRAM'),
				itemId:'program',
				name:'program'
			},{
				fieldLabel:getFeeAndPaymentCommonTranslation('BATCH'),
				itemId:'batch',
				name:'batch'
			},{
				fieldLabel:getFeeAndPaymentCommonTranslation('PERIOD'),
				itemId:'period',
				name:'period'
			},{
				fieldLabel:getFeeAndPaymentCommonTranslation('SECTION'),
				itemId:'section',
				name:'section'
			},{
				fieldLabel:getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
				itemId:'seatType',
				name:'seatType'

			}],listeners: {
				afterlayout: function(comp){
					var containerItems = comp.items.items;
					var contArray =[];
					Ext.each(containerItems,function(contItem){
						if(contItem.isVisible() == true){
							contArray.push(contItem);
						}
					});
					if(contArray.length == 0){
						comp.removeCls('addressPanelFieldCls');
						var addPanel = comp.up('addressdetailpanel');
						var sponsorTypeFieldContainer = addPanel.down('#sponserTypeFieldCont');
						sponsorTypeFieldContainer.el.setStyle('margin-top','-5px')
					}else if(contArray.length > 0) {
						comp.addCls('addressPanelFieldCls');
						var addPanel = comp.up('addressdetailpanel');
						var sponsorTypeFieldContainer = addPanel.down('#sponserTypeFieldCont');
						sponsorTypeFieldContainer.el.setStyle('margin-top','0px')
				
					}
				}
			}
		},{
			xtype:'fieldcontainer',
			layout:'vbox',
			cls:'addressPanelFieldCls',
			itemId:'sponserTypeFieldCont',
			width: 292,
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype: 'displayfield',
				style:{marginLeft:'10px'},
				labelStyle:'margin-top:10px !important;color:darkblue;',
				cls:'flyoutCommonDisplayFieldCls'
			},
			items:[{
			fieldLabel:getCommonTranslation('ENQUIRY_CONTACT_PERSON'),
			itemId:'contactPerson',
			name:'contactPerson',
				hidden:true
		},{
			fieldLabel:getFeeAndPaymentCommonTranslation('SPONSOR_TYPE_READ'),
			itemId:'sponsorType',
			name:'sponsorType',
				hidden:true
		},{
			fieldLabel:getFeeAndPaymentCommonTranslation('SPONSOR_CODE'),
			itemId:'sponsorCode',
			name:'sponsorCode',
				hidden:true
		},{
			fieldLabel:getFeeAndPaymentCommonTranslation('SPONSOR_STUDENT'),
			itemId:'noOfSponsoredStudents',
			name:'noOfSponsoredStudents',
				hidden:true
		},{
			fieldLabel:getFeeAndPaymentCommonTranslation('USER_ID'),
			itemId:'userId',
				name:'userId'
		},
		{
			fieldLabel:getFeeAndPaymentCommonTranslation('ACTUAL_USER_ID'),
			itemId:'actualUserId',
			name:'actualUserId',
				hidden:true
		},
			,
		{
			fieldLabel:getFeeAndPaymentCommonTranslation('PERSON_ID'),
			itemId:'person',
			name:'person',
				hidden:true
		},
		{
			fieldLabel:getCommonTranslation('STUDENT_ID'),
			itemId:'studentCode',
			name:'studentCode',
				hidden:true
		},{
			fieldLabel:getFeeAndPaymentCommonTranslation('DEPARTMENT_NAME'),
			itemId:'departmentName',
			name:'departmentName',
				hidden:true
			}],
			listeners: {
				afterlayout: function(comp){
					var containerItems = comp.items.items;
					var contArray =[];
					Ext.each(containerItems,function(contItem){
						if(contItem.isVisible() == true){
							contArray.push(contItem);
						}
					});
					if(contArray.length == 0){
						comp.removeCls('addressPanelFieldCls');
						var addPanel = comp.up('addressdetailpanel');
						var sponsorFieldContainer = addPanel.down('#sponsorFieldContainer');
						sponsorFieldContainer.el.setStyle('margin-top','-5px')
					}
					else if(contArray.length > 0) {
						comp.addCls('addressPanelFieldCls');
						var addPanel = comp.up('addressdetailpanel');
						var sponsorFieldContainer = addPanel.down('#sponsorFieldContainer');
						sponsorFieldContainer.el.setStyle('margin-top','0px')
				
					}
				}
			}
		},{
			xtype:'fieldcontainer',
			layout:'vbox',
			itemId:'sponsorFieldContainer',
				
			//style:{marginLeft:'10px'},
			width: 292,
			cls:'addressPanelFieldCls',
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype: 'displayfield',
				style:{marginLeft:'10px'},
				labelStyle:'margin-top:10px !important;color:darkblue;',
				cls:'flyoutCommonDisplayFieldCls'
			},
			items: [{
			fieldLabel:getCommonTranslation('CAST_CATEGORY'),
			itemId:'castCategoryName',
			name:'castCategoryName'
				
		},{
			fieldLabel:getFeeAndPaymentCommonTranslation('TOTAL_BALANCE'),
			itemId:'totalBalance',
			name:'totalBalance',
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)){
					if(value==0){
						return "0.0";
					}else {
						if(value>0){
							return  '<a href=# style= "color:darkblue">'+value+' Dr'+'</a>'
						}else{
							return  '<a href=# style= "color:darkblue">'+(value*-1)+' Cr'+'</a>'
						}
					}
				}else{
					return "";
				}
			}
				
		},{
			fieldLabel:getFeeAndPaymentCommonTranslation('TOTAL_BILL'),
			itemId:'totalAcadInvoiceAmount',
			name:'totalAcadInvoiceAmount',
			renderer:function(value,meta,record){
				if(value==0){
					return value;
				}
				else {
						return '<a href=# style= "color:darkblue">'+value+'</a>'
				}
			}
				
		},{
			fieldLabel:getFeeAndPaymentCommonTranslation('TOTAL_RECEIPT'),
			itemId:'totalAcadReceiptAmount',
			name:'totalAcadReceiptAmount',
			renderer:function(value,meta,record){
				if(value==0){
					return value;
				}
				else {
						return '<a href=# style= "color:darkblue">'+value+'</a>'
				}
			}
				
		},{
			fieldLabel:getFeeAndPaymentCommonTranslation('TOTAL_PAYMENT'),
			//itemId:'totalPaymentAmount',
			//name:'totalPaymentAmount',
			itemId:'totalAcadPaymentAmount',
			name:'totalAcadPaymentAmount',

			renderer:function(value,me,meta,record){
				var a=me.up('addressdetailpanel');
				var b=a.up();
				if(b.down('#receiptForm') && b.down('#receiptForm').getDisplayValue()=="SPONSOR")
					{		
						return value;
					}
				else if(value==0){
					return value;
				}
				else {
						return '<a href=# style= "color:darkblue">'+value+'</a>'
				}
			}
				
		},{
			fieldLabel:getFeeAndPaymentCommonTranslation('TOTAL_OUTSTANDING'),
			itemId:'totalConvertedOutstanding',
			name:'totalConvertedOutstanding',
			renderer:function(value,me,meta,record){
				var a=me.up('addressdetailpanel');
				var b=a.up();
				if(b.down('#receiptForm') && b.down('#receiptForm').getDisplayValue()=="SPONSOR")
					{		
						return value;
					}
				else if(value==0){
					return value;
				}
				else {
						return '<a href=# style= "color:darkblue">'+value+'</a>'
				}
			}
				
		},{
			fieldLabel:getFeeAndPaymentCommonTranslation('TOTAL_DISCOUNT'),
			itemId:'totalAcadDicountAmount',
			name:'totalAcadDicountAmount',
			renderer:function(value,me,meta,record){
				var a=me.up('addressdetailpanel');
				return value;
			}
				
		},{
			fieldLabel:getFeeAndPaymentCommonTranslation('TOTAL_ADVANCE_FEE'),
			itemId:'totalAcadLocAdvanceAmount',
			name:'totalAcadLocAdvanceAmount',
			renderer:function(value,me,meta,record){
				var a=me.up('addressdetailpanel');
				return value;
			}
				
			}],
			listeners: {
				afterlayout: function(comp){
					var containerItems = comp.items.items;
					var contArray =[];
					Ext.each(containerItems,function(contItem){
						if(contItem.isVisible() == true){
							contArray.push(contItem);
						}
					});
					if(contArray.length == 0){
						comp.removeCls('addressPanelFieldCls');
					}else if(contArray.length > 0) {
						comp.addCls('addressPanelFieldCls');
						
					}
				}
			}
		},{
			xtype:'fieldcontainer',
			layout:'vbox',
			cls:'addressPanelFieldCls',
			width: 292,
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype: 'displayfield',
				style:{marginLeft:'10px'},
				labelStyle:'margin-top:10px !important;color:darkblue;',
				cls:'flyoutCommonDisplayFieldCls'
			},
			items:[{
			fieldLabel:getFeeAndPaymentCommonTranslation('WHETHER_FACULTY'),
			itemId:'whetherFaculty',
			name:'whetherFaculty',
				hidden:true
		},{
			fieldLabel:getFeeAndPaymentCommonTranslation('WHETHER_INTERNAL'),
			itemId:'whetherInternal',
			name:'whetherInternal',
				hidden:true
		},{
			fieldLabel:getCommonTranslation('PROGRAM'),
			itemId:'programIdHidden',
			name:'programIdHidden',
				hidden:true
		},{
			fieldLabel:getCommonTranslation('BATCH'),
			itemId:'batchIdHidden',
			name:'batchIdHidden',
				hidden:true
			}],
			listeners: {
				afterlayout: function(comp){
					var containerItems = comp.items.items;
					var contArray =[];
					Ext.each(containerItems,function(contItem){
						if(contItem.isVisible() == true){
							contArray.push(contItem);
						}
					});
					if(contArray.length == 0){
						comp.removeCls('addressPanelFieldCls');
					}else if(contArray.length > 0) {
						comp.addCls('addressPanelFieldCls');
						
					}
				}
			}
		},
		{

			xtype:'fieldcontainer',
			layout:'vbox',
			cls:'flyoutLinkCls',
			width: 292,
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype: 'displayfield',
				style:{marginLeft:'10px',},
				labelStyle:'margin-top:10px !important;color:darkblue;'
		},
			items:[{
			itemId:'feeheadwisedistributionId',
			name:'feeheadwisedistributionId',
			hidden:true
			}],listeners: {
				afterlayout: function(comp){
					var containerItems = comp.items.items;
					var contArray =[];
					Ext.each(containerItems,function(contItem){
						if(contItem.isVisible() == true){
							contArray.push(contItem);
						}
					});
					if(contArray.length == 0){
						comp.removeCls('flyoutLinkCls');
					}else if(contArray.length > 0) {
						comp.addCls('flyoutLinkCls');
						
					}
				}
			}
		
		},{
			xtype:'fieldcontainer',
			layout:'vbox',
			cls:'flyoutLinkCls',
			width: 292,
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype: 'displayfield',
				style:{marginLeft:'10px',},
				labelStyle:'margin-top:10px !important;color:darkblue;'
		},
			items:[{
			itemId:'hosteldetailId',
			name:'hosteldetailId'
			}],listeners: {
				afterlayout: function(comp){
					var containerItems = comp.items.items;
					var contArray =[];
					Ext.each(containerItems,function(contItem){
						if(contItem.isVisible() == true){
							contArray.push(contItem);
						}
					});
					if(contArray.length == 0){
						comp.removeCls('flyoutLinkCls');
					}else if(contArray.length > 0) {
						comp.addCls('flyoutLinkCls');
						
					}
				}
			}
		},{
			xtype:'fieldcontainer',
			layout:'vbox',
			cls:'flyoutLinkCls',
			width: 292,
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype: 'displayfield',
				style:{marginLeft:'10px',},
				labelStyle:'margin-top:10px !important;color:darkblue;'
			},
			items:[{
			itemId:'transportdetailId',
			name:'transportdetailId'
			}],listeners: {
				afterlayout: function(comp){
					var containerItems = comp.items.items;
					var contArray =[];
					Ext.each(containerItems,function(contItem){
						if(contItem.isVisible() == true){
							contArray.push(contItem);
						}
					});
					if(contArray.length == 0){
						comp.removeCls('flyoutLinkCls');
					}else if(contArray.length > 0) {
						comp.addCls('flyoutLinkCls');
						
					}
				}
			}
		},{
			xtype:'fieldcontainer',
			layout:'vbox',
			cls:'flyoutLinkCls',
			width: 292,
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype: 'displayfield',
				style:{marginLeft:'10px',},
				labelStyle:'margin-top:10px !important;color:darkblue;'
			},
			items:[{
			itemId:'statementaccountId',
			name:'statementaccountId'

			}],listeners: {
				afterlayout: function(comp){
					var containerItems = comp.items.items;
					var contArray =[];
					Ext.each(containerItems,function(contItem){
						if(contItem.isVisible() == true){
							contArray.push(contItem);
						}
					});
					if(contArray.length == 0){
						comp.removeCls('flyoutLinkCls');
					}else if(contArray.length > 0) {
						comp.addCls('flyoutLinkCls');
						
					}
				}
			}
		}]
	}]
});
