Ext.define('Academia.view.common.ExtendedDateFilter',{
	extend:'Ext.button.Button',
	alias:'widget.extendeddatefilter',
	
    startDate: new Date(),
    endDate: new Date(),
   
    
	startDateLabel:'startDate',
	endDateLabel:'endDate',
    
    menu: {
    	cls:'dateFilterPanelCls',        
    	//cls:'customSearchNoPadding',
    	items:[{
        xtype: 'form',
        stype:{
            marginTop:'10px'
        },
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'form',
            width : '100%',
            cls:'panelNoSpace clsMenuDashboardProgramFilter',
            border: true,
            style:{
            	marginLeft:'11px !important;',
            	marginTop:'10px !important;'
            },
            /*layout: {
                type: 'vbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 150
            },*/
            items: [{
            	xtype: 'fieldcontainer',
            	layout: 'hbox',
            	width : '100%',
            	defaults: {
            		width: 100,
            		labelAlign: 'top'
            	},
            	items: [{
            		xtype:'displayfield',
            		fieldLabel:'Set Date',
            		width:61,
            		style:{
            			marginTop:'2px'
            		}
            	},{
            		xtype: 'button',
            		cls : 'dateFilterNotificationSearchBtn dateLabelCls',
            		text: getCommonTranslation('TODAY'),
            		itemId:'dashboardToDayBtn',            		
            		listeners: {
            			click: function(obj) {
            				this.up('extendeddatefilter').setDates(new Date(), new Date());
            				obj.getEl().addCls('dateFilterNotificationSearchBtnSelected');
                            obj.up('extendeddatefilter').down('#dashboardLastWeekBtn').removeCls('dateFilterNotificationSearchBtnSelected');
                            obj.up('extendeddatefilter').down('#dashboardLastMonthBtn').removeCls('dateFilterNotificationSearchBtnSelected');
            			}
            		}
            	}, {
            		xtype: 'button',
            		cls : 'dateFilterNotificationSearchBtn',
            		style:{
            			marginLeft:'14px !important;'
            		},
            		text: getCommonTranslation('LAST_WEEK'),
            		itemId:'dashboardLastWeekBtn',
            		listeners: {
            			click: function(obj) {
            				this.up('extendeddatefilter').setDates(Ext.Date.add(new Date(), Ext.Date.DAY, - 7), new Date());
            				obj.getEl().addCls('dateFilterNotificationSearchBtnSelected');
                            obj.up('extendeddatefilter').down('#dashboardToDayBtn').removeCls('dateFilterNotificationSearchBtnSelected');
                            obj.up('extendeddatefilter').down('#dashboardLastMonthBtn').removeCls('dateFilterNotificationSearchBtnSelected');
            			}
            		}
            	}, {
            		xtype: 'button',
            		cls : 'dateFilterNotificationSearchBtn',
            		text: getCommonTranslation('LAST_MONTH'),
            		itemId:'dashboardLastMonthBtn',
            		style:{
            			marginLeft:'14px !important;'
            		},
            		listeners: {
            			click: function(obj) {
            				this.up('extendeddatefilter').setDates(Ext.Date.add(new Date(), Ext.Date.DAY, - 30), new Date());
            				obj.getEl().addCls('dateFilterNotificationSearchBtnSelected');
                            obj.up('extendeddatefilter').down('#dashboardToDayBtn').removeCls('dateFilterNotificationSearchBtnSelected');
                            obj.up('extendeddatefilter').down('#dashboardLastWeekBtn').removeCls('dateFilterNotificationSearchBtnSelected');
            			}
            		}
            	}]
            },{
            	xtype: 'fieldcontainer',
            	layout: 'hbox',
            	width : '100%',
            	style:{
            		'margin-top':'8px !important'
            	},
            	defaults: {
            		width: 150,
            		labelAlign: 'top'
            	},
            	items: [{
        			xtype : 'customcombobox',
        			fieldLabel : getEnquiryTranslation('INTAKE_YEAR'),
        			name : 'intakeYear',
        			itemId : 'intakeYear',
        			displayField:'value',
        			valueField:'id',
        			/*typeAhead:true,
        			forceSelection:true,
        			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        			minChars:3,
        			listConfig: {
        				listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        					}
        				},
        				loadingText: getCommonTranslation('SEARCHING'),
        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        				getInnerTpl: function() {
        					return '<div class="search-item">' +
        					'{code}'  +
        					'</div>';
        				}
        			},*/
        			listeners  :{
        				render : function(combo){
        					var store=Ext.create('Academia.store.common.IntakeYearStore');
        					combo.bindStore(store)
        				}
        			}
    			},{
    				xtype : 'customcombobox',
    				name : 'academicYear',
    				itemId: 'academicYear',
    				fieldLabel : getFeeAndPaymentCommonTranslation('ACADEMIC_YEAR'),
    				store : 'program.programDetails.programBatches.PrimaryAcademicStore',
    				valueField : 'id',
    				displayField : 'yearName',
    				allowBlank : true,
    				hidden:true
    			},{
    				xtype : 'customcombobox',
    				name : 'academyYearTenure',			
    				itemId : 'academyYearTenure',			
    				fieldLabel : getCommonTranslation('ACADEMY_YEAR_TENURE'),//Current Academic Year Tenure
    				store : 'organization.academylocations.AcademicTenureStore',
    				valueField : 'id',
    				displayField : 'tenureName',
    				editable:false,
    				hidden:true
    			},{
                    xtype: 'datefield',
                    name: 'startDate',
                    width: 150,
                    fieldLabel: getAdmissionTranslation('START_DATE'),
                    vtype: 'daterange',
                    itemId: 'startDate',
                    editable:false,
                    endDateField: 'endDate',
                    allowBlank: false,
                    cls:'dateIconcls',
                  //--submitFormat: CONSTANTS.DATE_FORMAT,
                    listeners: {
                    	select: function(field, value) {
                            var dateRangePicker = this.up('extendeddatefilter');
                            var endDate = dateRangePicker.endDate;
                            dateRangePicker.setDates(value, endDate);
                        },
                        render: function(field) {
                        	return dateFormatRender(field);
                        }
                    }
                }, {
                    xtype: 'datefield',
                    width: 150,
                    name: 'endDate',
                    fieldLabel: getAdmissionTranslation('END_DATE'),
                    itemId: 'endDate',
                    vtype: 'daterange',
                    startDateField: 'startDate',
                    editable:false,
                    allowBlank: false,
                    cls:'dateIconcls',
                  //--submitFormat: CONSTANTS.DATE_FORMAT,
                    listeners: {
                    	select: function(field, value) {
                            var dateRangePicker = this.up('extendeddatefilter');
                            var startDate = dateRangePicker.startDate;
                            dateRangePicker.setDates(startDate,value);
                        },
                        render: function(field) {
                        	return dateFormatRender(field);
                        }
                    }
                }]
            }]
        }, {/*
            xtype: 'form',
            border: true,
            cls:'panelNoSpace',
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'datepicker',
                submitFormat: CONSTANTS.DATE_FORMAT,
                fieldLabel: getAdmissionTranslation('START_DATE'),
                value: new Date(),
                itemId: 'startDatePicker',
                handler: function(picker, date) {
                    var dateRangePicker = this.up('extendeddatefilter');
                    var endDate = dateRangePicker.endDate;
                    dateRangePicker.setDates(date, endDate);
                }
            }, {
                xtype: 'datepicker',
                submitFormat: CONSTANTS.DATE_FORMAT,
                fieldLabel: getAdmissionTranslation('END_DATE'),
                itemId: 'endDatePicker',
                value: new Date(),
                handler: function(picker, date) {
                    var dateRangePicker = this.up('extendeddatefilter');
                    var startDate = dateRangePicker.startDate;
                    dateRangePicker.setDates(startDate, date);
                }
            }]
        */}]
    }]
    },

	  setDates: function(startDate, endDate) {
          if (!startDate) startDate = new Date();

          if (!endDate) endDate = new Date();

          this.startDate = startDate;
          this.endDate = endDate;

          /*var startDatePicker = this.down('datepicker#startDatePicker');
          var endDatePicker = this.down('datepicker#endDatePicker');
          startDatePicker.setValue(startDate);
          endDatePicker.setValue(endDate);
          startDatePicker.setMaxDate(endDate);
          endDatePicker.setMinDate(startDate);
          */
          var startDateField = this.down('datefield#startDate');
          var endDateField = this.down('datefield#endDate');
          startDateField.setValue(startDate);
          endDateField.setValue(endDate);
          startDateField.setMaxValue(endDate);
          endDateField.setMinValue(startDate);

          var startDateValue = dateRender(startDate);
          var endDateValue = dateRender(endDate);
          this.setText(startDateValue + " "+getAdmissionTranslation('TO')+" " + endDateValue);
      },
      reset: function(){
    	  this.startDate=null;
    	  this.endDate=null;
    	  this.setText( getCommonTranslation('SELECT_DATE'));
      },
      
      getValues : function(){
    	   var startDateValue = Ext.Date.format(this.startDate, CONSTANTS.DATE_FORMAT);
           var endDateValue = Ext.Date.format(this.endDate, CONSTANTS.DATE_FORMAT);
           var value=new Object(),startDateLabel=this.startDateLabel,endDateLabel=this.endDateLabel;
           
           value[startDateLabel]=startDateValue;
           value[endDateLabel]=endDateValue;
    	  return value;
      }
});

