Ext.define('Academia.view.common.NotificationActivityGridExtendedDateFilter',{
	extend:'Ext.button.Button',
	alias:'widget.notificationactivitygridextendeddatefilter',
	
    startDate: new Date(),
    endDate: new Date(),
    
	startDateLabel:'startDate',
	endDateLabel:'endDate',
    
    menu: {
    	items:[{
        xtype: 'form',
        stype:{
            marginTop:'10px'
        },
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'form',
            cls:'panelNoSpace',
            border: true,
            items: [{
            		xtype : 'fieldcontainer',
            		width : '100%',
            		layout : {
            			type : 'hbox'
            		},
            		defaults : {
            			width : 100,
            			labelAlign : 'top'
            		},
            		items : [{
            			xtype: 'button',
                        cls : 'dateFilterNotificationSearchBtn',
                        itemId:'toDayBtn',
                        text: getCommonTranslation('TODAY'),
                        listeners: {
                            click: function(obj) {
                                this.up('notificationactivitygridextendeddatefilter').setDates(new Date(), new Date());
                                obj.getEl().addCls('dateFilterNotificationSearchBtnSelected');
                                obj.up('notificationactivitygridextendeddatefilter').down('#lastWeekBtn').removeCls('dateFilterNotificationSearchBtnSelected');
                                obj.up('notificationactivitygridextendeddatefilter').down('#lastMonthBtn').removeCls('dateFilterNotificationSearchBtnSelected');
                                var contentPanelMain = obj.up('activityfeeds');
	  							 if(contentPanelMain){
		  								 contentPanelMain.scrollBy(0,1);
		  								 contentPanelMain.scrollBy(0,-1);
	  							 }
                            }
                        }
            		},{
            			xtype: 'button',
                        cls : 'dateFilterNotificationSearchBtn',
                        itemId:'lastWeekBtn',
                        text: getCommonTranslation('LAST_WEEK'),
                        listeners: {
                            click: function(obj) {
                                this.up('notificationactivitygridextendeddatefilter').setDates(Ext.Date.add(new Date(), Ext.Date.DAY, - 7), new Date());
                                obj.getEl().addCls('dateFilterNotificationSearchBtnSelected');
                                obj.up('notificationactivitygridextendeddatefilter').down('#toDayBtn').removeCls('dateFilterNotificationSearchBtnSelected');
                                obj.up('notificationactivitygridextendeddatefilter').down('#lastMonthBtn').removeCls('dateFilterNotificationSearchBtnSelected');
                                var contentPanelMain = obj.up('activityfeeds');
	  							 if(contentPanelMain){
		  								 contentPanelMain.scrollBy(0,1);
		  								 contentPanelMain.scrollBy(0,-1);
	  							 }
                            }
                        }
            		},{
            			xtype: 'button',
                        cls : 'dateFilterNotificationSearchBtn',
                        itemId:'lastMonthBtn',
                        text: getCommonTranslation('LAST_MONTH'),
                        listeners: {
                            click: function(obj) {
                                this.up('notificationactivitygridextendeddatefilter').setDates(Ext.Date.add(new Date(), Ext.Date.DAY, - 30), new Date());
                                obj.getEl().addCls('dateFilterNotificationSearchBtnSelected');
                                obj.up('notificationactivitygridextendeddatefilter').down('#toDayBtn').removeCls('dateFilterNotificationSearchBtnSelected');
                                obj.up('notificationactivitygridextendeddatefilter').down('#lastWeekBtn').removeCls('dateFilterNotificationSearchBtnSelected');
                                var contentPanelMain = obj.up('activityfeeds');
	  							 if(contentPanelMain){
		  								 contentPanelMain.scrollBy(0,1);
		  								 contentPanelMain.scrollBy(0,-1);
	  							 }
                            }
                        }
            		}]
            	},{
            		xtype : 'fieldcontainer',
            		width : '100%',
            		layout : {
            			type : 'hbox'
            		},
            		defaults : {
            			width: 256,
            			labelAlign : 'top'
            		},
            		items : [{
            			xtype: 'datefield',
                        name: 'startDate',
                        width: 150,
                        fieldLabel: getAdmissionTranslation('START_DATE'),
                        vtype: 'daterange',
                        itemId: 'startDate',
                        endDateField: 'endDate',
                        allowBlank: false,
                      //--submitFormat: CONSTANTS.DATE_FORMAT,
                        listeners: {
                        	select: function(field, value) {
                                var dateRangePicker = this.up('notificationactivitygridextendeddatefilter');
                                var endDate = dateRangePicker.endDate;
                                dateRangePicker.setDates(value, endDate);
                                var contentPanelMain = this.up('activityfeeds');
	  							 if(contentPanelMain){
		  								 contentPanelMain.scrollBy(0,1);
		  								 contentPanelMain.scrollBy(0,-1);
	  							 }
                            },
                            render: function(field) {
                            	return dateFormatRender(field);
                            }
                        }
            		},{
            			 xtype: 'datefield',
                         width: 150,
                         name: 'endDate',
                         fieldLabel: getAdmissionTranslation('END_DATE'),
                         itemId: 'endDate',
                         vtype: 'daterange',
                         startDateField: 'startDate',
                         allowBlank: false,
                       //--submitFormat: CONSTANTS.DATE_FORMAT,
                         listeners: {
                         	select: function(field, value) {
                                 var dateRangePicker = this.up('notificationactivitygridextendeddatefilter');
                                 var startDate = dateRangePicker.startDate;
                                 dateRangePicker.setDates(startDate,value);
                                 var contentPanelMain = this.up('activityfeeds');
	  							 if(contentPanelMain){
		  								 contentPanelMain.scrollBy(0,1);
		  								 contentPanelMain.scrollBy(0,-1);
	  							 }
                             },
                             render: function(field) {
                             	return dateFormatRender(field);
                             }
                         }
            		}]
            	}]
        }]
    }]
    },

	  setDates: function(startDate, endDate) {
          if (!startDate) startDate = new Date();

          if (!endDate) endDate = new Date();

          this.startDate = startDate;
          this.endDate = endDate;
          var startDateField = this.down('datefield#startDate');
          var endDateField = this.down('datefield#endDate');
          startDateField.setValue(startDate);
          endDateField.setValue(endDate);
          startDateField.setMaxValue(endDate);
          endDateField.setMinValue(startDate);

          var startDateValue = Ext.Date.format(startDate, CONSTANTS.DATE_FORMAT);
          var endDateValue = Ext.Date.format(endDate, CONSTANTS.DATE_FORMAT);
          this.setText(startDateValue + " "+getAdmissionTranslation('TO')+" " + endDateValue);
      },
      reset: function(){
    	  this.startDate=null;
    	  this.endDate=null;
    	  this.setText( getCommonTranslation('SELECT_DATE'));
      },
      
      getValues : function(){
    	   var startDateValue = Ext.Date.format(this.startDate, CONSTANTS.DATE_FORMAT);
           var endDateValue = Ext.Date.format(this.endDate, CONSTANTS.DATE_FORMAT);
           var value=new Object(),startDateLabel=this.startDateLabel,endDateLabel=this.endDateLabel;
           
           value[startDateLabel]=startDateValue;
           value[endDateLabel]=endDateValue;
    	  return value;
      }
});

