/**
 * @author Rohit Thadani
 */
Ext.define('Academia.view.common.StudentPersonHostelRequirementForm', {
	//extend:'Academia.view.common.CustomFieldForm',
	extend:'Academia.view.common.IdGeneratorCustomForm',
    //customFieldEntity:CONSTANTS.APPLICANT_HOSTEL_REQUIREMENT_CF_DATA,
    customFieldEntity:CONSTANTS.STUDENT_HOSTEL_REQUIREMENT_CF_DATA,
    alias: 'widget.studentpersonhostelrequirementform',
    border: false,
    frame: true,
    title: getPersonModuleTranslation('HOSTEL_PERSONAL_REQUIREMENTS'),
    plugins: "formlabelrequired",
    cls: 'x-form-fixed-footer-parent',
    items: [{
        xtype: 'hidden',
        itemId: 'idItemId',
        name: 'id'
    },{
        xtype: 'hidden',
        name: 'version'
    }, {
    	xtype: 'fieldset',
		title: getAdmissionTranslation('HOSTEL_DETAILS'),
		style: {marginTop: '30px !important'},
		itemId:'hostelRequiredDetailsItemId',
		name: 'hostelRequiredDetails',
		items:[{
			xtype:'panel',
			layout:'vbox',
			cls: 'panelNoSpace',
			items:[{
		        xtype: 'fieldcontainer',
		        width: 'auto',
		        defaults: {
		            labelAlign: 'top',
		            width: 256
		        },
		        layout: 'hbox',
		        items: [{
			    		xtype: 'checkboxfield',
			    		//name: 'whetherHostelRequired',
			    		name: 'whetherHostelApplicable',
			    		boxLabel: getPersonModuleTranslation('IS_HOSTEL_REQUIRED'),
			    		itemId:'isHostelRequired',
			    		inputValue : true,
			    		uncheckedValue: false,
			    		labelSeparator : '',
			    		style: {
			    			//marginTop: '25px'
			    		}
			    	}]
				},{
			         xtype: 'fieldcontainer',
			         itemId:'hostelFieldsContainer1',
			         width: 'auto',
			         defaults: {
			             labelAlign: 'top',
			             width: 256
			         },
			         layout: 'hbox',
			         items: [{
			             xtype: 'textfield',
			             name: 'dietaryRequirements',
			             itemId: 'dietaryRequirementsItemId',
			             fieldLabel: getPersonModuleTranslation('WHETHER_DIETARY_REQUIREMENTS'),
			             labelSeparator : '',
			             maxLength: 255
			         }, {
			             xtype: 'textfield',
			             name: 'foodAllergies',
			             itemId: 'foodAllergiesItemId',
			             fieldLabel: getPersonModuleTranslation('WHETHER_FOOD_ALLERGIC'),
			             labelSeparator : '',
			             maxLength: 255
			         }, {
			             xtype: 'textfield',
			             name: 'sleepingDisorder',
			             itemId: 'sleepingDisorderItemId',
			             fieldLabel: getPersonModuleTranslation('WHETHER_SLEEPING_DISORDER'),
			             labelSeparator : '',
			             maxLength: 255
			         }]
			     },{

			         xtype: 'fieldcontainer',
			         itemId:'hostelFieldsContainer2',
			         width: 'auto',
			         defaults: {
			             labelAlign: 'top',
			             width: 256
			         },
			         layout: 'hbox',
			         items: [{
			             xtype: 'textfield',
			             name: 'anyMedicalNeedsOrSomething',
			             itemId: 'anyMedicalNeedsOrSomethingItemId',
			             fieldLabel: getPersonModuleTranslation('WHETHER_MED_EMO_PHYSICAL_NEED'),
			             labelSeparator : '',
			             maxLength: 255
			         }]
			     
			     
			     },{
			         xtype: 'panel',
			         itemId: 'hostelPreferencePanel',
			         style: {
			        	 marginLeft: '0px',
		             },
			         items: [{
			             xtype: 'fieldcontainer',
			             width: 'auto',
				         defaults: {
				             labelAlign: 'top',
				             width: 256
				         },
			             layout: {
			                 type: 'hbox',
			                 align: 'bottom'
			             },
			            
			             items: [{
			                 xtype: 'customcombobox',
			     			fieldLabel: getAdmissionTranslation('LOCATION'),
			                 name: 'stdAcademyLocationCombo',
			                 itemId:'stdAcademyLocationCombo',
			                 store:Ext.create('Academia.store.organization.academylocations.StoOrgLocationGetSearchStore'),
			                 displayField: 'value',
			                 valueField: 'id',
			                 forceSelection:true,
			                 typeAhead : false,
			                 height:'auto',
				     		 autoloadStore: false,
			             },{
				             xtype: 'nestedJsonCombo',
				             name: 'studentHostelDetails1',
				             labelSeparator : '',
				             addAllSelector: false,
				             itemId: 'studentHostelDetailsId1',
				             store:Ext.create('Academia.store.servicerequest.servicerequestsettings.AssigneeApproverHostelLocationWiseStore'),
				             fieldLabel: getCommonTranslation('HOSTEL_CHOICE_FIRST_PREFERENCE'),
				     		 displayField: 'hostelName',
			                 valueField: 'hostelId',
				     		 forceSelection:true,
				     		 typeAhead:false,
				     		 cls:'multiBrandCampusCls',
				     		 height:'auto',
				     		 autoloadStore: false,
				     		 listConfig :{         
								listeners :{ 
									beforeshow: function(picker) {
			        					picker.width = picker.up('combobox').getSize().width;
			        				},
			        				beforeselect : function(combo,record,index,opts) {
			        					if (combo.getCount() == 3) {
			        						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('HOSTEL_SELECTION_EXCEEDS_MSG'));
			                                return false;
		                              }
		                          },
		                      },
							}
				         },{
				             xtype: 'nestedJsonCombo',
				             name: 'studentHostelDetails2',
				             addAllSelector: false,
				             itemId: 'studentHostelDetailsId2',
				             store:Ext.create('Academia.store.servicerequest.servicerequestsettings.AssigneeApproverHostelLocationWiseStore'),
				             fieldLabel: getCommonTranslation('HOSTEL_CHOICE_SECOND_PREFERENCE'),
				     		 displayField: 'hostelName',
			                 valueField: 'hostelId',
				     		 forceSelection:true,
				     		 typeAhead:false,
				     		 labelSeparator : '',
				     		 cls:'multiBrandCampusCls',
				     		 height:'auto',
				     		 autoloadStore: false,
				     		 listConfig :{         
								listeners :{ 
									beforeshow: function(picker) {
			        					picker.width = picker.up('combobox').getSize().width;
			        				},
			        				beforeselect : function(combo,record,index,opts) {
			        					if (combo.getCount() == 3) {
			        						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('HOSTEL_SELECTION_EXCEEDS_MSG'));
			                                return false;
		                              }
		                          },
		                      },
							}
				         }, {
				             xtype: 'nestedJsonCombo',
				             name: 'studentHostelDetails3',
				             addAllSelector: false,
				             itemId: 'studentHostelDetailsId3',
				             store: Ext.create('Academia.store.servicerequest.servicerequestsettings.AssigneeApproverHostelLocationWiseStore'),
				             fieldLabel: getCommonTranslation('HOSTEL_CHOICE_THIRD_PREFERENCE'),
				     		 displayField: 'hostelName',
			                 valueField: 'hostelId',
				     		 forceSelection:true,
				     		 typeAhead:false,
				     		 cls:'multiBrandCampusCls',
				     		 height:'auto',
				     		 autoloadStore: false,
				     		 listConfig :{         
								listeners :{ 
									beforeshow: function(picker) {
			        					picker.width = picker.up('combobox').getSize().width;
			        				},
			        				beforeselect : function(combo,record,index,opts) {
			        					if (combo.getCount() == 3) {
			        						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('HOSTEL_SELECTION_EXCEEDS_MSG'));
			                                return false;
		                              }
		                          },
		                      },
							}
				         },{
			         		xtype : 'button',
			         		itemId: 'btnAddHostelPreference0',
			         		cls: 'CustomBodyBtnSettings',
			 				text: getCommonTranslation('ADDBUTTONTEXT'),
			 				tooltip: getCommonTranslation('ADD')
			         	}]
			         }]
			     },{
			         xtype: 'fieldcontainer',
			         itemId:'hostelFieldsContainer3',
			         width: 'auto',
			         defaults: {
			             labelAlign: 'top',
			             width: 256
			         },
			         layout: 'hbox',
			         items: [{
			             xtype: 'radiogroup',
			             name: 'tempAccommondation',
			             itemId: 'tempAccommondationId',
			             height: 80,
			             fieldLabel: getCommonTranslation('TEMPORARY_ACCOMMODATION_NEEDED'),
			             style: {
		                     marginTop: '5px'
		                 },
		                 defaults: {
		                     flex: .1
		                 },
		                 items: [{
		                	 boxLabel: getCommonTranslation('YES'),
		                	 name: 'tempAccommondationType',
		                	 inputValue: true
		                 }, {
			                 boxLabel: getCommonTranslation('No'),
			                 name: 'tempAccommondationType',
			                 inputValue: false,
			                 checked: true
			             }]
			         }]
			     
			     }]
		}]
    }
    ,{
        xtype: 'fieldcontainer',
        cls: 'form-fixed-footer',
        style: {
            //marginLeft: '-2px',
            marginTop: '20px'
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
            //hidden: true
        }]
    }]
});