/**
 * @author kuldeep.yadav
 */
Ext.define('Academia.view.completion.PassOutRejectButtonForm',{
	extend: 'Ext.window.Window',
	alias: 'widget.passoutrejectbuttonform',
	title:getExaminationTranslation('REJECT_CONFIRMATION'),
	frame: true,
	//autoScroll:true,
	modal:true,
	method: 'POST',
	width:550,
	height:250,
	//maxHeight: 600,
	resizable:true,
	items: [{
		xtype: 'form',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		itemId:'passoutrejectform',
		defaults: {
			labelAlign: 'top',
		},
		standardSubmit: false,
		items: [{ 	
			   xtype:'fieldcontainer',
	    	   width:'auto',
	    	//   cls : 'windowBtnPos',
			   items: [{
					xtype: 'textarea',
					name: 'rejectRemark',
					labelAlign: 'top',
					itemId:'rejectRemark',
					fieldLabel: getExaminationTranslation('REJECT_REMARK'),
					width:450,
					maxLength:255,
					enterIsSpecial:true,
					height:100,
					allowBlank: false,
					validator: function(value) {        // (,.!'@&*|;")
		          			var validChars = /^(?! )[a-zA-Z0-9\s|,!"'.:()]+$/;
		                    if(!isNullOrEmpty(value)&&!validChars.test(value)){           
		                        return 'Invalid Chars';    
		                    }else{return true ; }}
				}]
		       },{ 	
		   xtype:'fieldcontainer',
    	   width:'auto',
    	//   cls : 'windowBtnPos',
		   items: [{
		    	 xtype: 'button',
				 action: 'Confirm',
				 text: getExaminationTranslation('CONFIRM'),
				 formBind: true,
				 disabled:true,
				 itemId: 'submitBtnWin',
				 ui: 'CustomBtnSubmit',
				 scale: CONSTANTS.BUTTONSIZE	 
		      },{
				 xtype: 'button',
				 text: getFeeAndPaymentCommonTranslation('CANCEL'),
				 ui: 'CustomBtnCancel',
				 disabled:false,
				 itemId: 'cancelBtn',
				 scale: CONSTANTS.BUTTONSIZE
		      }]
	       }]
		}]	
});