Ext.define('Academia.view.completion.completionlist.PrintCertificateWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.printcertificatewindow',
	modal : true,
	resizable: true,
	overflowX: 'hidden',
	overflowY: 'auto',
	frame: true,
	width: 536,
	minHeight: 232,
	bodyStyle: {
		padding: '15px 16px 0 16px !important'
	},
	title: getCommonTranslation('PRINT_CERTIFICATE'),
	items:[{
		xtype: 'form',
		plugins: "formlabelrequired",
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width: '100%',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'textfield',
				hidden: true,
				name: 'completionIds',
				itemId: 'completionIds'
			}, {
				xtype: 'multiselectcombofield',
				name: 'certificateName',
				fieldLabel: getCommonTranslation('CERTIFICATE_NAME'),
				itemId: 'certificateNameId',
				store:'completion.completionform.CertificateNamesStore',
				forceSelection : true,
				allowBlank: false,
				displayField: 'certificateName',
				valueField: 'certificateId',
				autoloadStore: false,
				listeners: {
					change: function() {
						if(Ext.isArray(this.getValue()) && isNaN(this.getValue()[0])) {
							var arr = [];
							for(var i = 0; i < this.getValue().length; i++) {
								arr.push(this.getValue()[i].get('certificateId'));
							}
							this.nextSibling().setValue(arr.join());
						}
						else {
							this.nextSibling().setValue(this.getValue().join());
						}
					},
					select: function(field, value) {
						var window =this.up('printcertificatewindow');
						var form=window.down("form");
						var formValues=form.getValues();
						
						if(formValues.isPrintWordDoc){  
							form.down('#sendToStudentProfileBtn').setDisabled(true);
						}else{
							form.down('#sendToStudentProfileBtn').setDisabled(false);
						}
					} 
				}
			}, {
				xtype: 'textfield',
				hidden: true,
				name: 'certificateIds',
				itemId: 'certificateIds'
			}]
		}, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width: '100%',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			margin: '8 0 8 0',
			items: [{
				xtype: 'checkboxfield',
				boxLabel: getCommonTranslation('PRINT_AS_WORD_FILE'),
				name: 'isPrintWordDoc',
				inputValue: true,
				uncheckedValue: false,
				listeners: {
                    change: function(checkbox, newValue) {
                    	var button = checkbox.up('form').down('#sendToStudentProfileBtn'); //Ext.ComponentQuery.query('#sendToStudentProfileBtn')[0]; // Querying button component by itemId
                        if(newValue){
                            button.setDisabled(newValue);
                            } else{
                            button.setDisabled(newValue);	
                            }
                        
                        }
                }
			}]
		}, {
			xtype: 'fieldcontainer',
			width: '100%',
			items: [{
				xtype: 'button',
				text: getCompletionModuleTranslation('SUBMIT'),
				itemId: 'submitBtnId',
				ui: 'CustomBtnSubmit',
				formBind: true,  
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCompletionModuleTranslation('SEND_TO_STUDENT_PROFILE'),
				itemId: 'sendToStudentProfileBtn',
				ui: 'CustomBtnSubmit',
//				formBind: true,  
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCompletionModuleTranslation('CANCEL'),
				itemId: 'cancelBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});