/**
 * @author pritam.patil
 * Issue Certificates Details Grid 
 */
Ext.define('Academia.view.completion.completionlistforms.common.CompletionDocumentGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.completiondocumentgrid',
    title : getCompletionModuleTranslation('DOCUMENT_DETAILS'),
    border: true,
    viewConfig: {
        stripeRows: true
    },
    selModel: {    		    					
	    mode: 'SINGLE'
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAddCompletionDoc',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:true
    },{
        xtype: 'button',
        itemId: 'btnEditCompletionDoc',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
       
    },{
        xtype: 'button',
        itemId: 'btnViewCompletionDoc',
        tooltip:getCommonTranslation('VIEW'), 
        iconCls: 'view-icon'
       
    },{
        xtype: 'button',
        itemId: 'btnDeleteCompletionDoc',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
    }],
    
    columns: [{
		header : getCompletionModuleTranslation('DOCUMENTS_TYPE'),
		dataIndex : 'documentType',
		sortable : true,
		flex : .2,
		renderer : function(value, metadata, record){
			var msg = "";
			if(!isEmpty(value) && record.get('isElectronic')==true){
				msg = '<a href="#">'+columnObjRender(value,"value")+'</a>';
			}else{
				msg = columnObjRender(value,"value");
			}
			return msg;
		}
	},{
        header: getCompletionModuleTranslation('STATUS'),
        dataIndex: 'status',
        sortable: true,
        flex: .2,
        renderer : function(value){
        	if(value === 'PENDING'){
        		return  getCompletionModuleTranslation('PENDING');
        	}else if(value === 'SUBMITTED'){
        		return  getCompletionModuleTranslation('SUBMITTED');
        	}else if (value === 'RETURNED'){
        		return  getCompletionModuleTranslation('RETURNED');
        	}else if (value === 'INSPECTED'){
        		return  getCompletionModuleTranslation('INSPECTED');
        	}
        }
    }, {
        header: getCompletionModuleTranslation('RETURNABLE'),
        dataIndex: 'isReturnable',
        sortable: true,
        flex: .2,
        renderer : function(value){
        	if(value === true){
        		return  getCompletionModuleTranslation('YES');
        	}else{
        		return  getCompletionModuleTranslation('NO');
        	}
        }
    },{
        header: getCompletionModuleTranslation('RETURN_DATE'),
        dataIndex: 'returnedDate',
        sortable: true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    },{
        header: getCompletionModuleTranslation('RETURN_MODE'),
        dataIndex: 'modeOfReturn',
        sortable: true,
        flex: .2,
        renderer:function(fieldValue) {
			return getPersonModuleTranslation(fieldValue);
		}
    }],
    initComponent: function() {
       var this$ = this;
       var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,            
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
   buildStore: function() {
        return Ext.create('Academia.store.completion.completionform.CompletionDocuments');
    }

});
