/**
 * @author pritam.patil
 * Completion Pending Payment Grid
 */
Ext.define('Academia.view.completion.completionlistforms.common.CompletionPendingPaymentGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.completionpendingpaymentgrid',
    border: true,
    viewConfig: {
        stripeRows: true
    },
    plugins : [ {
		ptype : 'rowexpander',
		rowBodyTpl : [ '<tpl for="."><tpl if="!Ext.isEmpty(studentPendingPaymentRefundHeadWiseDetails)">',
		               	'<table style="border:1px solid black; width:90%;">',

		               	'<col style="width:10%">',
		                '<col style="width:10%">',
		                '<col style="width:20%">',
		                '<col style="width:20%">',
		                '<col style="width:10%">',
		                '<col style="width:10%">',
		                '<col style="width:10%">',
		                '<col style="width:10%">',
		                '<thead>',
		                '<tr>',
		                        '<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">'+getCompletionModuleTranslation('BILL_NO')+'</th>',
		                        '<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">'+getCompletionModuleTranslation('BILLING_DATE')+'</th>',
		                        '<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">'+getCompletionModuleTranslation('FEE_PLAN_NAME')+'</th>',
		                        '<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">'+getCompletionModuleTranslation('FEE_HEAD_NAME')+'</th>',
		                        '<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">'+getCompletionModuleTranslation('FEE_AMOUNT')+'</th>',
		                        '<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">'+getCompletionModuleTranslation('DISCOUNT_AMOUNT')+'</th>',
		                        '<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">'+getCompletionModuleTranslation('ADJUSTED_AMOUNT')+'</th>',
		                        '<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">'+getCompletionModuleTranslation('BALANCE_AMOUNT')+'</th>',
		                '</tr>',
		                '</thead>',
		               		'<tpl for="studentPendingPaymentRefundHeadWiseDetails">',
		               			'<tr>',
		               				'<td style="width:100px;text-align:center">{billNo}</td>',
		               				'<td style="width:100px;text-align:center">{billingDate}</td>',
		               				'<td style="width:100px;text-align:center">{feePlanName}</td>',
		               				'<td style="width:100px;text-align:center">{feeHeadName}</td>',
		               				'<td style="width:100px;text-align:center">{feeAmount}</td>',
		               				'<td style="width:100px;text-align:center">{discountAmount}</td>',
		               				'<td style="width:100px;text-align:center">{adjustedAmount}</td>',
		               				'<td style="width:100px;text-align:center">{balanceAmount}</td>',
		               			'</tr>',
		               		'</tpl>',
		               	'</table></tpl>',
		               '</tpl>' ]
	} ],
    columns: [{
        header: getCompletionModuleTranslation('PAYMENT_VOUCHER_NO'),
        dataIndex: 'paymentVoucher',
        sortable: true,
        flex: .2
    },{
        header: getCompletionModuleTranslation('PAYMENT_DATE'),
        dataIndex: 'paymentDate',
        sortable: true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getCompletionModuleTranslation('AMOUNT'),
        dataIndex: 'amount',
        sortable: true,
        flex: .2
    }, {
        header: getCompletionModuleTranslation('INSTRUMENT_DETAILS'),
        dataIndex: 'voucherMode',
        sortable: true,
        flex: .2,
        renderer: function(value){
        	if(!isNullOrEmpty(value)){
        		return '<a href="#">'+value+'</a>';
        	}else{
        		return value;
        	}
        	
        }
    }],
    initComponent: function() {
       var this$ = this;
       var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
   buildStore: function() {
        return Ext.create('Academia.store.completion.completionform.PendingPayments');
    }

});
